/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.clibano;

import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.properties.ClibanoCenterType;
import com.stal111.forbidden_arcanus.common.block.properties.ClibanoSideType;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoMenu;
import com.stal111.forbidden_arcanus.common.recipe.ClibanoRecipe;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.ModRecipes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class ClibanoMainBlockEntity
extends BaseContainerBlockEntity
implements RecipeHolder {
    public static final int SOUL_DURATION = 2700;
    public static final int DATA_SOUL_TIME = 0;
    public static final int DATA_BURN_TIME = 1;
    public static final int DATA_BURN_DURATION = 2;
    public static final int DATA_COOKING_PROGRESS_FIRST = 3;
    public static final int DATA_COOKING_PROGRESS_SECOND = 4;
    public static final int DATA_COOKING_DURATION_FIRST = 5;
    public static final int DATA_COOKING_DURATION_SECOND = 6;
    public static final int DATA_FIRE_TYPE = 7;
    public static final int DATA_COUNT = 8;
    public static final RecipeType<ClibanoRecipe> RECIPE_TYPE = (RecipeType)ModRecipes.CLIBANO_COMBUSTION.get();
    public static final Function<ItemStack, Optional<ClibanoFireType>> ITEM_TO_FIRE_TYPE = stack -> {
        if (stack.m_150930_((Item)ModItems.SOUL.get()) || stack.m_150930_((Item)ModItems.DARK_SOUL.get())) {
            return Optional.of(ClibanoFireType.BLUE_FIRE);
        }
        return Optional.empty();
    };
    private final NonNullList<ItemStack> inventoryContents = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private int soulTime;
    private int burnTime;
    private int burnDuration;
    private int cookingProgressFirst;
    private int cookingProgressSecond;
    private int cookingDurationFirst;
    private int cookingDurationSecond;
    private ClibanoFireType fireType = ClibanoFireType.FIRE;
    private Direction frontDirection = Direction.NORTH;
    private boolean wasLit = false;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ClibanoMainBlockEntity.this.soulTime;
                case 1 -> ClibanoMainBlockEntity.this.burnTime;
                case 2 -> ClibanoMainBlockEntity.this.burnDuration;
                case 3 -> ClibanoMainBlockEntity.this.cookingProgressFirst;
                case 4 -> ClibanoMainBlockEntity.this.cookingProgressSecond;
                case 5 -> ClibanoMainBlockEntity.this.cookingDurationFirst;
                case 6 -> ClibanoMainBlockEntity.this.cookingDurationSecond;
                case 7 -> ClibanoMainBlockEntity.this.fireType.ordinal();
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ClibanoMainBlockEntity.this.setSoulTime(value);
                    break;
                }
                case 1: {
                    ClibanoMainBlockEntity.this.burnTime = value;
                    break;
                }
                case 2: {
                    ClibanoMainBlockEntity.this.burnDuration = value;
                    break;
                }
                case 3: {
                    ClibanoMainBlockEntity.this.cookingProgressFirst = value;
                    break;
                }
                case 4: {
                    ClibanoMainBlockEntity.this.cookingProgressSecond = value;
                    break;
                }
                case 5: {
                    ClibanoMainBlockEntity.this.cookingDurationFirst = value;
                    break;
                }
                case 6: {
                    ClibanoMainBlockEntity.this.cookingDurationSecond = value;
                    break;
                }
                case 7: {
                    ClibanoMainBlockEntity.this.fireType = ClibanoFireType.values()[value];
                }
            }
        }

        public int m_6499_() {
            return 8;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();

    public ClibanoMainBlockEntity(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CLIBANO_MAIN.get(), worldPosition, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ClibanoMainBlockEntity blockEntity) {
        ItemStack soul;
        boolean canSmeltSecond;
        SimpleContainer firstSlot = new SimpleContainer(new ItemStack[]{(ItemStack)blockEntity.inventoryContents.get(((Integer)ClibanoMenu.INPUT_SLOTS.getFirst()).intValue())});
        SimpleContainer secondSlot = new SimpleContainer(new ItemStack[]{(ItemStack)blockEntity.inventoryContents.get(((Integer)ClibanoMenu.INPUT_SLOTS.getSecond()).intValue())});
        ClibanoRecipe firstRecipe = level.m_7465_().m_44015_(RECIPE_TYPE, (Container)firstSlot, level).orElse(null);
        ClibanoRecipe secondRecipe = level.m_7465_().m_44015_(RECIPE_TYPE, (Container)secondSlot, level).orElse(null);
        boolean isLit = blockEntity.burnTime > 0;
        boolean canSmeltFirst = firstRecipe != null && blockEntity.canBurn(firstRecipe, blockEntity.m_6893_(), (Integer)ClibanoMenu.INPUT_SLOTS.getFirst());
        boolean bl = canSmeltSecond = secondRecipe != null && blockEntity.canBurn(secondRecipe, blockEntity.m_6893_(), (Integer)ClibanoMenu.INPUT_SLOTS.getSecond());
        if (blockEntity.soulTime != 0) {
            --blockEntity.soulTime;
            if (blockEntity.soulTime == 0) {
                blockEntity.changeFireType(level, ClibanoFireType.FIRE, firstRecipe, secondRecipe);
            }
        } else if ((canSmeltFirst || canSmeltSecond) && !(soul = blockEntity.m_8020_(1)).m_41619_()) {
            blockEntity.soulTime = 2700;
            blockEntity.changeFireType(level, ITEM_TO_FIRE_TYPE.apply(soul).orElse(ClibanoFireType.FIRE), firstRecipe, secondRecipe);
            soul.m_41774_(1);
        }
        if (isLit) {
            --blockEntity.burnTime;
        } else {
            if (canSmeltFirst || canSmeltSecond) {
                ItemStack fuel = blockEntity.m_8020_(2);
                blockEntity.burnDuration = 0;
                if (!fuel.m_41619_()) {
                    blockEntity.burnDuration = blockEntity.burnTime = blockEntity.getBurnDuration(fuel);
                    fuel.m_41774_(1);
                    if (!blockEntity.wasLit) {
                        blockEntity.updateAppearance(level);
                    }
                    blockEntity.m_6596_();
                }
            }
            if (blockEntity.cookingProgressFirst != 0 || blockEntity.cookingProgressSecond != 0) {
                blockEntity.cookingProgressFirst = Math.max(0, blockEntity.cookingProgressFirst - 2);
                blockEntity.cookingProgressSecond = Math.max(0, blockEntity.cookingProgressSecond - 2);
                blockEntity.m_6596_();
            }
            if (blockEntity.wasLit) {
                blockEntity.updateAppearance(level);
            }
            blockEntity.wasLit = false;
            return;
        }
        if (canSmeltFirst) {
            blockEntity.cookingDurationFirst = firstRecipe.getCookingTime(blockEntity.fireType);
            ++blockEntity.cookingProgressFirst;
            if (blockEntity.cookingProgressFirst == blockEntity.cookingDurationFirst) {
                blockEntity.finishRecipe(firstRecipe, (Integer)ClibanoMenu.INPUT_SLOTS.getFirst());
            }
            blockEntity.m_6596_();
        } else {
            blockEntity.cookingProgressFirst = 0;
        }
        if (canSmeltSecond) {
            blockEntity.cookingDurationSecond = secondRecipe.getCookingTime(blockEntity.fireType);
            ++blockEntity.cookingProgressSecond;
            if (blockEntity.cookingProgressSecond == blockEntity.cookingDurationSecond) {
                blockEntity.finishRecipe(secondRecipe, (Integer)ClibanoMenu.INPUT_SLOTS.getSecond());
            }
            blockEntity.m_6596_();
        } else {
            blockEntity.cookingProgressSecond = 0;
        }
        blockEntity.wasLit = true;
    }

    private boolean canBurn(ClibanoRecipe recipe, int maxCount, int slot) {
        NonNullList<ItemStack> items = this.inventoryContents;
        if (((ItemStack)items.get(slot)).m_41619_()) {
            return false;
        }
        ItemStack stack = recipe.m_8043_();
        if (stack.m_41619_()) {
            return false;
        }
        ItemStack resultStack = (ItemStack)items.get(((Integer)ClibanoMenu.RESULT_SLOTS.getFirst()).intValue());
        ItemStack secondResultStack = (ItemStack)items.get(((Integer)ClibanoMenu.RESULT_SLOTS.getSecond()).intValue());
        if (resultStack.m_41619_() || secondResultStack.m_41619_()) {
            return true;
        }
        if (!resultStack.m_41656_(stack) && !secondResultStack.m_41656_(stack)) {
            return false;
        }
        if (resultStack.m_41613_() + stack.m_41613_() <= maxCount && resultStack.m_41613_() + stack.m_41613_() <= resultStack.m_41741_()) {
            return true;
        }
        if (secondResultStack.m_41613_() + stack.m_41613_() <= maxCount && secondResultStack.m_41613_() + stack.m_41613_() <= secondResultStack.m_41741_()) {
            return true;
        }
        return resultStack.m_41613_() + stack.m_41613_() <= stack.m_41741_() || secondResultStack.m_41613_() + stack.m_41613_() <= stack.m_41741_();
    }

    private void finishRecipe(ClibanoRecipe recipe, int slot) {
        NonNullList<ItemStack> items = this.inventoryContents;
        ItemStack stack = recipe.m_8043_();
        ((ItemStack)items.get(slot)).m_41774_(1);
        if (slot == (Integer)ClibanoMenu.INPUT_SLOTS.getFirst()) {
            this.cookingProgressFirst = 0;
        } else {
            this.cookingProgressSecond = 0;
        }
        if (stack.m_41619_()) {
            return;
        }
        ItemStack resultStack = (ItemStack)items.get(((Integer)ClibanoMenu.RESULT_SLOTS.getFirst()).intValue());
        ItemStack secondResultStack = (ItemStack)items.get(((Integer)ClibanoMenu.RESULT_SLOTS.getSecond()).intValue());
        if (resultStack.m_41656_(stack) && resultStack.m_41613_() + stack.m_41613_() <= resultStack.m_41741_()) {
            resultStack.m_41769_(stack.m_41613_());
        } else if (secondResultStack.m_41656_(stack) && secondResultStack.m_41613_() + stack.m_41613_() <= secondResultStack.m_41741_()) {
            secondResultStack.m_41769_(stack.m_41613_());
        } else if (resultStack.m_41619_()) {
            items.set(((Integer)ClibanoMenu.RESULT_SLOTS.getFirst()).intValue(), (Object)stack.m_41777_());
        } else if (secondResultStack.m_41619_()) {
            items.set(((Integer)ClibanoMenu.RESULT_SLOTS.getSecond()).intValue(), (Object)stack.m_41777_());
        }
        this.m_6029_((Recipe<?>)recipe);
    }

    private void changeFireType(Level level, ClibanoFireType fireType, @Nullable ClibanoRecipe firstRecipe, @Nullable ClibanoRecipe secondRecipe) {
        int oldDuration;
        this.fireType = fireType;
        if (firstRecipe != null) {
            oldDuration = this.cookingDurationFirst;
            this.cookingDurationFirst = firstRecipe.getCookingTime(fireType);
            this.cookingProgressFirst = (int)((float)this.cookingProgressFirst / (float)oldDuration * (float)this.cookingDurationFirst);
        }
        if (secondRecipe != null) {
            oldDuration = this.cookingDurationSecond;
            this.cookingDurationSecond = secondRecipe.getCookingTime(fireType);
            this.cookingProgressSecond = (int)((float)this.cookingProgressSecond / (float)oldDuration * (float)this.cookingDurationSecond);
        }
        this.updateAppearance(level);
        this.m_6596_();
    }

    private void updateAppearance(Level level) {
        ClibanoCenterType centerType = ClibanoCenterType.FRONT_OFF;
        ClibanoSideType sideType = ClibanoSideType.OFF;
        if (this.burnTime > 0) {
            if (this.fireType == ClibanoFireType.FIRE) {
                centerType = ClibanoCenterType.FRONT_FIRE;
                sideType = ClibanoSideType.FIRE;
            } else if (this.fireType == ClibanoFireType.BLUE_FIRE) {
                centerType = ClibanoCenterType.FRONT_BLUE_FIRE;
                sideType = ClibanoSideType.BLUE_FIRE;
            }
        }
        BlockPos frontCenterPos = this.f_58858_.m_142300_(this.frontDirection);
        BlockState center = (BlockState)level.m_8055_(frontCenterPos).m_61124_(ModBlockStateProperties.CLIBANO_CENTER_TYPE, (Comparable)((Object)centerType));
        level.m_46597_(frontCenterPos, center);
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_() == this.frontDirection.m_122434_()) continue;
            BlockState side = (BlockState)level.m_8055_(frontCenterPos.m_142300_(direction)).m_61124_(ModBlockStateProperties.CLIBANO_SIDE_TYPE, (Comparable)((Object)sideType));
            level.m_46597_(frontCenterPos.m_142300_(direction), side);
        }
    }

    public void setFrontDirection(Direction direction) {
        this.frontDirection = direction;
    }

    @Nonnull
    protected Component m_6820_() {
        return new TranslatableComponent("container.forbidden_arcanus.clibano");
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int containerId, @Nonnull Inventory inventory) {
        return new ClibanoMenu(containerId, (Container)this, inventory, this.containerData);
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventoryContents);
        tag.m_128405_("SoulTime", this.soulTime);
        tag.m_128405_("BurnTime", this.burnTime);
        tag.m_128405_("CookingProgressFirst", this.cookingProgressFirst);
        tag.m_128405_("CookingProgressSecond", this.cookingProgressSecond);
        tag.m_128405_("CookingDurationFirst", this.cookingDurationFirst);
        tag.m_128405_("CookingDurationSecond", this.cookingDurationSecond);
        tag.m_128359_("FireType", this.fireType.m_7912_());
        tag.m_128359_("FrontDirection", this.frontDirection.m_122433_());
        this.recipesUsed.forEach((resourceLocation, integer) -> tag.m_128405_(resourceLocation.toString(), integer.intValue()));
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.inventoryContents.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventoryContents);
        this.soulTime = tag.m_128451_("SoulTime");
        this.burnTime = tag.m_128451_("BurnTime");
        this.burnDuration = this.getBurnDuration((ItemStack)this.inventoryContents.get(2));
        this.cookingProgressFirst = tag.m_128451_("CookingProgressFirst");
        this.cookingProgressSecond = tag.m_128451_("CookingProgressSecond");
        this.cookingDurationFirst = tag.m_128451_("CookingDurationFirst");
        this.cookingDurationSecond = tag.m_128451_("CookingDurationSecond");
        this.fireType = ClibanoFireType.byName(tag.m_128461_("FireType")).orElse(ClibanoFireType.FIRE);
        this.frontDirection = Direction.m_122402_((String)tag.m_128461_("FrontDirection"));
        for (String recipe : tag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(recipe), tag.m_128451_(recipe));
        }
    }

    public void setSoulTime(int duration) {
        this.soulTime = duration;
    }

    public int m_6643_() {
        return this.inventoryContents.size();
    }

    protected int getBurnDuration(ItemStack fuel) {
        if (fuel.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)fuel, RECIPE_TYPE);
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe == null) {
            return;
        }
        this.recipesUsed.addTo((Object)recipe.m_6423_(), 1);
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_8015_(@Nonnull Player player) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        player.m_7281_(this.getRecipesToAwardAndPopExperience(player.m_183503_(), player.m_20182_()));
        this.recipesUsed.clear();
    }

    public Collection<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 position) {
        ArrayList list = new ArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add((Recipe<?>)recipe);
                ClibanoMainBlockEntity.createExperience(level, position, entry.getIntValue(), ((ClibanoRecipe)((Object)recipe)).m_43750_());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 position, int count, float experience) {
        int i = Mth.m_14143_((float)((float)count * experience));
        float f = Mth.m_14187_((float)((float)count * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)position, (int)i);
    }

    public boolean m_7983_() {
        return this.inventoryContents.stream().allMatch(ItemStack::m_41619_);
    }

    @Nonnull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    @Nonnull
    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = ContainerHelper.m_18969_(this.inventoryContents, (int)index, (int)count);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.inventoryContents, (int)index);
    }

    public void m_6836_(int index, @Nonnull ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(@Nonnull Player player) {
        if (this.m_58904_() == null || this.m_58904_().m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.inventoryContents.clear();
    }
}

