/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity;

import com.stal111.forbidden_arcanus.common.aureal.AurealHelper;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class NipaBlockEntity
extends BlockEntity {
    private int lastSpeck = 0;
    private int speckHeight = 10;
    private Map<UUID, Integer> players = new HashMap<UUID, Integer>();
    private int cachedPower = 0;

    public NipaBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.NIPA.get(), pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, NipaBlockEntity blockEntity) {
        if (blockEntity.speckHeight < 75) {
            ++blockEntity.speckHeight;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NipaBlockEntity blockEntity) {
        if (!((Boolean)state.m_61143_((Property)ModBlockStateProperties.SPECK)).booleanValue()) {
            ++blockEntity.lastSpeck;
            if (blockEntity.lastSpeck >= 3600) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ModBlockStateProperties.SPECK, (Comparable)Boolean.valueOf(true)));
                blockEntity.lastSpeck = 0;
            }
        }
        if (level.m_46467_() % 20L == 0L) {
            AABB axisAlignedBB = new AABB(pos).m_82400_(3.0);
            List playersInRange = level.m_45976_(Player.class, axisAlignedBB);
            HashMap<UUID, Integer> players = new HashMap<UUID, Integer>();
            for (Player player : playersInRange) {
                UUID uuid = player.m_142081_();
                players.put(uuid, blockEntity.players.getOrDefault(uuid, 0) + 1);
                if ((Integer)players.get(uuid) != 30) continue;
                AurealHelper.increaseAureal(player, 1);
                players.remove(uuid);
            }
            blockEntity.players = players;
        }
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.lastSpeck = tag.m_128451_("LastSpeck");
        this.players.clear();
        ListTag players = tag.m_128437_("Players", 10);
        players.forEach(nbt -> {
            if (nbt instanceof CompoundTag) {
                CompoundTag player = (CompoundTag)nbt;
                this.players.put(player.m_128342_("Player"), player.m_128451_("Time"));
            }
        });
    }

    public void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("LastSpeck", this.lastSpeck);
        ListTag players = new ListTag();
        this.players.forEach((uuid, integer) -> {
            CompoundTag player = new CompoundTag();
            player.m_128362_("Player", uuid);
            player.m_128405_("Time", integer.intValue());
            players.add((Object)player);
        });
        tag.m_128365_("Players", (Tag)players);
    }

    public double getSpeckHeight() {
        return (float)this.speckHeight / 100.0f;
    }

    public void setSpeckHeight(int speckHeight) {
        this.speckHeight = speckHeight;
    }

    public int getCachedPower() {
        return this.cachedPower;
    }

    public void setCachedPower(int cachedPower) {
        this.cachedPower = cachedPower;
    }
}

