/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity;

import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.util.ModTags;
import com.stal111.forbidden_arcanus.util.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlackHoleBlockEntity
extends BlockEntity {
    private static final double DAMAGE_DISTANCE = 0.6;
    private static final int PLAYER_SEARCH_DISTANCE = 6;
    private final List<ItemEntity> thrownOutItems = new ArrayList<ItemEntity>();
    private double stored_xp;
    public int rotation = 0;
    public int tickCounter;
    public int auraTexture = 0;

    public BlackHoleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BLACK_HOLE.get(), pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlackHoleBlockEntity blockEntity) {
        ++blockEntity.rotation;
        ++blockEntity.tickCounter;
        if (blockEntity.tickCounter == 5 || blockEntity.tickCounter == 10) {
            ++blockEntity.auraTexture;
        } else if (blockEntity.tickCounter == 15) {
            blockEntity.tickCounter = 0;
            blockEntity.auraTexture = 0;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlackHoleBlockEntity blockEntity) {
        List entities = level.m_45933_(null, new AABB((double)pos.m_123341_() + 0.5 - 5.0, (double)pos.m_123342_() + 0.5 - 5.0, (double)pos.m_123343_() + 0.5 - 5.0, (double)pos.m_123341_() + 0.5 + 5.0, (double)pos.m_123342_() + 0.5 + 5.0, (double)pos.m_123343_() + 0.5 + 5.0));
        for (Entity entity : entities) {
            ItemEntity itemEntity2;
            if (!entity.m_6095_().m_204039_(ModTags.EntityTypes.BLACK_HOLE_AFFECTED) || entity instanceof ItemEntity && !blockEntity.isAffectedItem(itemEntity2 = (ItemEntity)entity)) continue;
            double distance = entity.m_20182_().m_82554_(ModUtils.blockPosToVector(pos, 0.5));
            double movementFactor = blockEntity.getMovementFactor(distance);
            entity.m_5997_(((double)pos.m_123341_() + 0.5 - entity.m_20185_()) * movementFactor, ((double)pos.m_123342_() + 0.5 - entity.m_20186_() + 1.25) * movementFactor, ((double)pos.m_123343_() + 0.5 - entity.m_20189_()) * movementFactor);
            if (!(distance <= 0.6)) continue;
            if (entity instanceof ExperienceOrb) {
                ExperienceOrb experienceOrb = (ExperienceOrb)entity;
                blockEntity.stored_xp += (double)experienceOrb.m_20801_();
                if (blockEntity.stored_xp >= 60.0) {
                    blockEntity.throwOutItemStack(level, new ItemStack((ItemLike)ModItems.XPETRIFIED_ORB.get()), pos);
                    blockEntity.stored_xp = 0.0;
                }
                experienceOrb.m_6074_();
                continue;
            }
            entity.m_6469_(DamageSource.f_19319_, 4.0f);
        }
        blockEntity.thrownOutItems.removeIf(itemEntity -> !itemEntity.m_6084_());
    }

    public boolean isAffectedItem(ItemEntity entity) {
        return !this.thrownOutItems.contains(entity) && !entity.m_32055_().m_204117_(ModTags.Items.BLACK_HOLE_UNAFFECTED);
    }

    private void throwOutItemStack(Level level, ItemStack stack, BlockPos pos) {
        pos = pos.m_142022_(0.5, 0.5, 0.5);
        ItemEntity item = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
        Player nearestPlayer = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 6.0, false);
        if (nearestPlayer == null) {
            this.setRandomVelocity(item, level.m_5822_());
        } else {
            item.m_5997_((nearestPlayer.m_20185_() - item.m_20185_()) * 0.09, (nearestPlayer.m_20186_() - item.m_20186_() + 1.25) * 0.09, (nearestPlayer.m_20189_() - item.m_20189_()) * 0.09);
        }
        this.thrownOutItems.add(item);
        level.m_7967_((Entity)item);
    }

    private double getMovementFactor(double distance) {
        return distance <= 3.0 ? 0.035 : 0.02;
    }

    private void setRandomVelocity(ItemEntity itemEntity, Random random) {
        double x = random.nextDouble();
        double y = random.nextDouble();
        double z = random.nextDouble();
        itemEntity.m_20334_(random.nextBoolean() ? x : -x, random.nextBoolean() ? y : -y, random.nextBoolean() ? z : -z);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.stored_xp = tag.m_128459_("StoredXP");
    }

    public void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128347_("StoredXP", this.stored_xp);
    }
}

