/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.block.properties.PillarType;
import java.util.EnumMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;

public class PillarBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<PillarType> TYPE = ModBlockStateProperties.PILLAR_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape[] SHAPE_PARTS = new VoxelShape[]{Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0)};
    private final EnumMap<PillarType, EnumMap<Direction.Axis, VoxelShape>> shapes;

    public PillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(TYPE, (Comparable)((Object)PillarType.SINGLE))).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapes = this.buildShapes();
    }

    private EnumMap<PillarType, EnumMap<Direction.Axis, VoxelShape>> buildShapes() {
        EnumMap<PillarType, EnumMap<Direction.Axis, VoxelShape>> map = new EnumMap<PillarType, EnumMap<Direction.Axis, VoxelShape>>(PillarType.class);
        map.put(PillarType.MIDDLE, VoxelShapeHelper.rotateAxis((VoxelShape)SHAPE_PARTS[2]));
        map.put(PillarType.TOP, VoxelShapeHelper.rotateAxis((VoxelShape)Shapes.m_83124_((VoxelShape)SHAPE_PARTS[0], (VoxelShape[])new VoxelShape[]{SHAPE_PARTS[1], SHAPE_PARTS[2]})));
        map.put(PillarType.BOTTOM, VoxelShapeHelper.rotateAxis((VoxelShape)Shapes.m_83124_((VoxelShape)SHAPE_PARTS[3], (VoxelShape[])new VoxelShape[]{SHAPE_PARTS[4], SHAPE_PARTS[2]})));
        map.put(PillarType.SINGLE, VoxelShapeHelper.rotateAxis((VoxelShape)VoxelShapeHelper.combineAll((VoxelShape[])SHAPE_PARTS)));
        return map;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.shapes.get(state.m_61143_(TYPE)).get(state.m_61143_((Property)f_55923_));
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction.m_122434_() != state.m_61143_((Property)f_55923_)) {
            return state;
        }
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)this.tryConnect(state, level, currentPos)));
    }

    private PillarType tryConnect(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)f_55923_);
        BlockState stateDown = level.m_8055_(pos.m_142300_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis)));
        BlockState stateUp = level.m_8055_(pos.m_142300_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis)));
        boolean axisUpEqual = stateUp.m_60713_((Block)this) && stateUp.m_61143_((Property)f_55923_) == axis;
        boolean axisDownEqual = stateDown.m_60713_((Block)this) && stateDown.m_61143_((Property)f_55923_) == axis;
        return PillarType.getTypeForConnections(axisUpEqual, axisDownEqual);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, f_55923_, WATERLOGGED});
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

