/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.stal111.forbidden_arcanus.common.block.entity.NipaBlockEntity;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NipaBlock
extends BushBlock
implements EntityBlock {
    public static final BooleanProperty SPECK = ModBlockStateProperties.SPECK;
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);

    public NipaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SPECK, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new NipaBlockEntity(pos, state);
    }

    public boolean m_6864_(@Nonnull BlockState state, @Nonnull BlockPlaceContext useContext) {
        return false;
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        NipaBlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)SPECK)).booleanValue() && (blockEntity = (NipaBlockEntity)level.m_7702_(pos)) != null) {
            this.harvestSpeck(state, level, pos, blockEntity);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        NipaBlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && ((Boolean)state.m_61143_((Property)SPECK)).booleanValue() && (blockEntity = (NipaBlockEntity)level.m_7702_(pos)) != null) {
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + blockEntity.getSpeckHeight(), (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.ARCANE_CRYSTAL_DUST_SPECK.get())));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6861_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        NipaBlockEntity blockEntity = (NipaBlockEntity)level.m_7702_(pos);
        if (blockEntity != null) {
            int power = level.m_46755_(pos);
            if (((Boolean)state.m_61143_((Property)SPECK)).booleanValue() && blockEntity.getCachedPower() != power && power != 0) {
                this.harvestSpeck(state, level, pos, blockEntity);
            }
            blockEntity.setCachedPower(power);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    public void m_7100_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_150109_().m_36063_(ModItems.Stacks.LENS_OF_VERITATIS)) {
            double j = 0.4 * (double)rand.nextFloat();
            double k = 0.4 * (double)rand.nextFloat();
            double posX = (double)pos.m_123341_() + 0.5 + (rand.nextBoolean() ? j : -j);
            double posY = (double)pos.m_123342_() + 0.1 + (double)rand.nextFloat() / 2.5;
            double posZ = (double)pos.m_123343_() + 0.5 + (rand.nextBoolean() ? k : -k);
            double ySpeed = ((double)rand.nextFloat() - 0.4) * 0.1;
            level.m_7106_((ParticleOptions)ModParticles.AUREAL_MOTE.get(), posX, posY, posZ, 0.0, ySpeed, 0.0);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> blockEntityType) {
        if (level.m_5776_() && ((Boolean)state.m_61143_((Property)SPECK)).booleanValue()) {
            return BaseEntityBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.NIPA.get()), NipaBlockEntity::clientTick);
        }
        if (!level.m_5776_()) {
            return BaseEntityBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.NIPA.get()), NipaBlockEntity::serverTick);
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SPECK});
    }

    private void harvestSpeck(BlockState state, Level world, BlockPos pos, NipaBlockEntity blockEntity) {
        world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + blockEntity.getSpeckHeight(), (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.ARCANE_CRYSTAL_DUST_SPECK.get())));
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)SPECK, (Comparable)Boolean.valueOf(false)));
        blockEntity.setSpeckHeight(10);
    }
}

