/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.stal111.forbidden_arcanus.common.block.ModBlockPatterns;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.item.RitualStarterItem;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;

public class HephaestusForgeBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty ACTIVATED = ModBlockStateProperties.ACTIVATED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)VoxelShapeHelper.combineAll((VoxelShape[])new VoxelShape[]{HephaestusForgeBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), HephaestusForgeBlock.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), HephaestusForgeBlock.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), HephaestusForgeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}), (VoxelShape)VoxelShapeHelper.combineAll((VoxelShape[])new VoxelShape[]{HephaestusForgeBlock.m_49796_((double)0.0, (double)15.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), HephaestusForgeBlock.m_49796_((double)3.0, (double)15.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0)}), (BooleanOp)BooleanOp.f_82685_);

    public HephaestusForgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new HephaestusForgeBlockEntity(pos, state);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        this.updateState(state, level, pos);
        if (((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue()) {
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof HephaestusForgeBlockEntity) {
                HephaestusForgeBlockEntity blockEntity2 = (HephaestusForgeBlockEntity)blockEntity;
                ItemStack stack = player.m_21120_(hand);
                if (stack.m_41720_() instanceof RitualStarterItem) {
                    blockEntity2.getRitualManager().tryStartRitual((ServerLevel)level, stack, player);
                } else {
                    player.m_5893_((MenuProvider)blockEntity2);
                }
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void updateState(BlockState state, Level level, BlockPos pos) {
        BlockPattern.BlockPatternMatch patternHelper = ModBlockPatterns.BASE_HEPHAESTUS_PATTERN.m_61184_((LevelReader)level, pos.m_7495_());
        if (patternHelper == null || patternHelper.m_61234_() != Direction.DOWN) {
            if (((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue()) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
            }
        } else if (!((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> blockEntityType) {
        if (level.m_5776_()) {
            return BaseEntityBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.HEPHAESTUS_FORGE.get()), HephaestusForgeBlockEntity::clientTick);
        }
        return BaseEntityBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.HEPHAESTUS_FORGE.get()), HephaestusForgeBlockEntity::serverTick);
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVATED, WATERLOGGED});
    }
}

