/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.aureal.consequence;

import com.stal111.forbidden_arcanus.common.aureal.AurealHelper;
import com.stal111.forbidden_arcanus.common.aureal.consequence.Consequence;
import com.stal111.forbidden_arcanus.common.aureal.consequence.ConsequenceType;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.valhelsia.valhelsia_core.common.util.NeedsStoring;

public class SoundConsequence
extends Consequence
implements NeedsStoring {
    private static final List<SoundEvent> SOUNDS = List.of(SoundEvents.f_12442_, SoundEvents.f_11837_, SoundEvents.f_11924_);
    private static final int CONSEQUENCE_DURATION = 1800;
    private int ticksUntilNextSound = 20;
    private int timer = 0;

    public SoundConsequence(ConsequenceType<?> type) {
        super(type);
    }

    @Override
    public void tick(Player player) {
        if (!player.m_20193_().m_5776_()) {
            Random random = player.m_21187_();
            if (this.ticksUntilNextSound <= 0) {
                player.m_6330_(SOUNDS.get(random.nextInt(SOUNDS.size())), SoundSource.PLAYERS, 1.0f, 1.0f);
                this.ticksUntilNextSound = Math.max(random.nextInt(450), 100);
            } else {
                --this.ticksUntilNextSound;
            }
            ++this.timer;
            if (this.timer >= 1800) {
                AurealHelper.getCapability(player).removeActiveConsequence(this);
                AurealHelper.sendAurealUpdatePacket(player);
            }
        }
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128405_("TicksUntilNextSound", this.ticksUntilNextSound);
        tag.m_128405_("Timer", this.timer);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.ticksUntilNextSound = tag.m_128451_("TicksUntilNextSound");
        this.timer = tag.m_128451_("Timer");
    }
}

