/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.aureal;

import com.stal111.forbidden_arcanus.common.aureal.capability.AurealImpl;
import com.stal111.forbidden_arcanus.common.aureal.capability.AurealProvider;
import com.stal111.forbidden_arcanus.common.aureal.capability.IAureal;
import com.stal111.forbidden_arcanus.common.aureal.consequence.Consequence;
import com.stal111.forbidden_arcanus.common.aureal.consequence.Consequences;
import com.stal111.forbidden_arcanus.common.network.NetworkHandler;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateAurealPacket;
import com.stal111.forbidden_arcanus.core.config.AurealConfig;
import java.util.Objects;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.valhelsia.valhelsia_core.common.util.NeedsStoring;

public class AurealHelper {
    public static IAureal getCapability(Player player) {
        return (IAureal)player.getCapability(AurealProvider.CAPABILITY).orElse((Object)new AurealImpl());
    }

    public static int getAureal(Player player) {
        return AurealHelper.getCapability(player).getAureal();
    }

    public static void increaseAureal(Player player, int amount) {
        AurealHelper.getCapability(player).increaseAureal(amount);
        AurealHelper.sendAurealUpdatePacket(player);
    }

    public static void increaseCorruption(Player player, int amount) {
        IAureal aureal = AurealHelper.getCapability(player);
        Random random = player.m_21187_();
        for (int i = 0; i < amount; ++i) {
            aureal.increaseCorruption(1);
            int corruption = aureal.getCorruption();
            if (corruption <= 10 || ((Boolean)AurealConfig.DISABLE_CONSEQUENCES.get()).booleanValue() || !(random.nextDouble() < (double)((float)(corruption + 3) / 185.0f))) continue;
            Object consequence = Consequences.getRandomConsequence(random).create();
            ((Consequence)consequence).tick(player);
            if (!(consequence instanceof NeedsStoring)) continue;
            aureal.addActiveConsequence((Consequence)consequence);
        }
        AurealHelper.sendAurealUpdatePacket(player);
    }

    public static void playerTick(Player player) {
        IAureal aureal = AurealHelper.getCapability(player);
        aureal.tickActiveConsequences(player);
        if (!((Boolean)AurealConfig.NATURAL_CORRUPTION_DECREASEMENT.get()).booleanValue()) {
            return;
        }
        if (aureal.getCorruption() >= 1) {
            aureal.setCorruptionTimer(aureal.getCorruptionTimer() + 1);
            if (aureal.getCorruptionTimer() >= (Integer)AurealConfig.NATURAL_CORRUPTION_DECREASEMENT_TIME.get()) {
                aureal.setCorruption(aureal.getCorruption() - 1);
                aureal.setCorruptionTimer(0);
                AurealHelper.sendAurealUpdatePacket(player);
            }
        } else if (aureal.getCorruptionTimer() != 0) {
            aureal.setCorruptionTimer(0);
        }
    }

    public static void sendAurealUpdatePacket(Player player) {
        NetworkHandler.sendTo(player, new UpdateAurealPacket(player));
    }

    public static CompoundTag save(CompoundTag tag, IAureal aureal) {
        tag.m_128405_("Corruption", aureal.getCorruption());
        tag.m_128405_("CorruptionTimer", aureal.getCorruptionTimer());
        tag.m_128405_("Aureal", aureal.getAureal());
        if (!aureal.getActiveConsequences().isEmpty()) {
            ListTag consequences = new ListTag();
            for (Consequence consequence : aureal.getActiveConsequences()) {
                NeedsStoring needsStoring;
                if (!(consequence instanceof NeedsStoring) || !(needsStoring = (NeedsStoring)consequence).shouldBeSaved()) continue;
                CompoundTag consequenceTag = new CompoundTag();
                consequenceTag.m_128359_("Type", consequence.getName().toString());
                consequences.add((Object)needsStoring.save(consequenceTag));
            }
            tag.m_128365_("ActiveConsequences", (Tag)consequences);
        }
        return tag;
    }

    public static IAureal load(CompoundTag tag, IAureal aureal) {
        aureal.setCorruption(tag.m_128451_("Corruption"));
        aureal.setCorruptionTimer(tag.m_128451_("CorruptionTimer"));
        aureal.setAureal(tag.m_128451_("Aureal"));
        if (tag.m_128441_("ActiveConsequences")) {
            ListTag consequences = tag.m_128437_("ActiveConsequences", 10);
            for (Tag listEntry : consequences) {
                if (!(listEntry instanceof CompoundTag)) continue;
                CompoundTag consequenceTag = (CompoundTag)listEntry;
                ResourceLocation name = new ResourceLocation(consequenceTag.m_128461_("Type"));
                Object consequence = Objects.requireNonNull(Consequences.getByName(name)).create();
                if (consequence instanceof NeedsStoring) {
                    NeedsStoring needsStoring = (NeedsStoring)consequence;
                    needsStoring.load(consequenceTag);
                }
                aureal.addActiveConsequence((Consequence)consequence);
            }
        }
        return aureal;
    }
}

