/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.stal111.forbidden_arcanus.common.block.ObsidianSkullBlock;
import com.stal111.forbidden_arcanus.common.block.ObsidianWallSkullBlock;
import com.stal111.forbidden_arcanus.common.block.entity.ObsidianSkullBlockEntity;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ObsidianSkullRenderer
implements BlockEntityRenderer<ObsidianSkullBlockEntity> {
    public static final ModelLayerLocation OBSIDIAN_SKULL_LAYER = new ModelLayerLocation(new ResourceLocation("forbidden_arcanus", "obsidian_skull"), "main");
    public static final ModelLayerLocation ETERNAL_OBSIDIAN_SKULL_LAYER = new ModelLayerLocation(new ResourceLocation("forbidden_arcanus", "eternal_obsidian_skull"), "main");
    private static final ResourceLocation TEXTURE = new ResourceLocation("forbidden_arcanus", "textures/block/obsidian_skull.png");
    private static final ResourceLocation ETERNAL_TEXTURE = new ResourceLocation("forbidden_arcanus", "textures/block/eternal_obsidian_skull.png");
    private final Pair<SkullModel, SkullModel> models;

    public static Pair<SkullModel, SkullModel> createModels(EntityModelSet modelSet) {
        return Pair.of((Object)new SkullModel(modelSet.m_171103_(OBSIDIAN_SKULL_LAYER)), (Object)new SkullModel(modelSet.m_171103_(ETERNAL_OBSIDIAN_SKULL_LAYER)));
    }

    public ObsidianSkullRenderer(BlockEntityRendererProvider.Context context) {
        this.models = ObsidianSkullRenderer.createModels(context.m_173585_());
    }

    private static MeshDefinition createBaseMesh() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        return meshDefinition;
    }

    public static LayerDefinition createObsidianSkullLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)ObsidianSkullRenderer.createBaseMesh(), (int)32, (int)16);
    }

    public static LayerDefinition createEternalObsidianSkullLayer() {
        MeshDefinition meshdefinition = ObsidianSkullRenderer.createBaseMesh();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171597_("head").m_171599_("layer", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)16);
    }

    public void render(ObsidianSkullBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState state = blockEntity.m_58900_();
        boolean flag = state.m_60734_() instanceof ObsidianWallSkullBlock;
        Direction direction = flag ? (Direction)state.m_61143_((Property)ObsidianWallSkullBlock.FACING) : null;
        float rotation = flag ? (float)(2 + direction.m_122416_()) * 4.0f : (float)((Integer)state.m_61143_((Property)ObsidianSkullBlock.ROTATION)).intValue();
        ObsidianSkullRenderer.render(direction, 22.5f * rotation, poseStack, buffer, combinedLight, this.models, state.m_60734_());
    }

    public static void render(@Nullable Direction direction, float rotation, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, Pair<SkullModel, SkullModel> models, Block block) {
        SkullModel model;
        poseStack.m_85836_();
        boolean eternal = block == ModBlocks.ETERNAL_OBSIDIAN_SKULL.get() || block == ModBlocks.ETERNAL_OBSIDIAN_WALL_SKULL.get();
        SkullModel skullModel = model = eternal ? (SkullModel)models.getSecond() : (SkullModel)models.getFirst();
        if (direction == null) {
            poseStack.m_85837_(0.5, 0.0, 0.5);
        } else {
            poseStack.m_85837_((double)(0.5f - (float)direction.m_122429_() * 0.25f), 0.25, (double)(0.5f - (float)direction.m_122431_() * 0.25f));
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110464_((ResourceLocation)(eternal ? ETERNAL_TEXTURE : TEXTURE)));
        model.m_142698_(0.0f, rotation, 0.0f);
        model.m_7695_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

