/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client;

import com.stal111.forbidden_arcanus.client.gui.overlay.FlightTimerOverlay;
import com.stal111.forbidden_arcanus.client.gui.overlay.ObsidianSkullOverlay;
import com.stal111.forbidden_arcanus.client.gui.overlay.SanityMeterOverlay;
import com.stal111.forbidden_arcanus.client.gui.screen.ClibanoScreen;
import com.stal111.forbidden_arcanus.client.gui.screen.HephaestusForgeScreen;
import com.stal111.forbidden_arcanus.client.tooltip.ClientEdelwoodBucketTooltip;
import com.stal111.forbidden_arcanus.client.tooltip.EdelwoodBucketTooltip;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.item.BloodTestTubeItem;
import com.stal111.forbidden_arcanus.common.item.SpectralEyeAmuletItem;
import com.stal111.forbidden_arcanus.common.item.UtremJarItem;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.other.ModContainers;
import com.stal111.forbidden_arcanus.core.init.other.ModWoodTypes;
import com.stal111.forbidden_arcanus.util.FullbrightBakedModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Triple;

public class ClientSetup {
    private final List<Triple<Block, StatePropertiesPredicate, Function<BakedModel, BakedModel>>> bakedModelOverrideRegistry = new ArrayList<Triple<Block, StatePropertiesPredicate, Function<BakedModel, BakedModel>>>();

    public ClientSetup() {
        Minecraft minecraft = Minecraft.m_91087_();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::onModelBake);
        modEventBus.addListener(this::onTextureStitch);
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.HEPHAESTUS_FORGE.get()), HephaestusForgeScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.CLIBANO.get()), ClibanoScreen::new);
            Sheets.addWoodType((WoodType)ModWoodTypes.FUNGYSS);
            Sheets.addWoodType((WoodType)ModWoodTypes.CHERRYWOOD);
            Sheets.addWoodType((WoodType)ModWoodTypes.MYSTERYWOOD);
            Sheets.addWoodType((WoodType)ModWoodTypes.EDELWOOD);
        });
        MinecraftForgeClient.registerTooltipComponentFactory(EdelwoodBucketTooltip.class, ClientEdelwoodBucketTooltip::new);
        this.registerModelOverride(ModBlocks.RUNIC_CHISELED_POLISHED_DARKSTONE, StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)ModBlockStateProperties.ACTIVATED, true).m_67706_(), base -> new FullbrightBakedModel((BakedModel)base, new ResourceLocation("forbidden_arcanus", "block/runic_chiseled_polished_darkstone_layer")));
        this.registerModelOverride(ModBlocks.XPETRIFIED_ORE, base -> new FullbrightBakedModel((BakedModel)base, new ResourceLocation("forbidden_arcanus", "block/xpetrified_ore_layer")));
        this.registerModelOverride(ModBlocks.ARCANE_CRYSTAL_ORE, base -> new FullbrightBakedModel((BakedModel)base, new ResourceLocation("forbidden_arcanus", "block/arcane_crystal_ore/arcane_crystal_ore_layer")));
        this.registerModelOverride(ModBlocks.DEEPSLATE_ARCANE_CRYSTAL_ORE, base -> new FullbrightBakedModel((BakedModel)base, new ResourceLocation("forbidden_arcanus", "block/arcane_crystal_ore/arcane_crystal_ore_layer")));
        this.registerModelOverride(ModBlocks.RUNIC_STONE, base -> new FullbrightBakedModel((BakedModel)base, new ResourceLocation("forbidden_arcanus", "block/runic_stone/rune_layer")));
        this.registerModelOverride(ModBlocks.RUNIC_DEEPSLATE, base -> new FullbrightBakedModel((BakedModel)base, new ResourceLocation("forbidden_arcanus", "block/runic_stone/rune_layer")));
        this.registerModelOverride(ModBlocks.RUNIC_DARKSTONE, base -> new FullbrightBakedModel((BakedModel)base, new ResourceLocation("forbidden_arcanus", "block/runic_stone/rune_layer")));
        this.registerModelOverride(ModBlocks.ARCANE_CRYSTAL_BLOCK, base -> new FullbrightBakedModel((BakedModel)base, new ResourceLocation("forbidden_arcanus", "block/arcane_crystal_block")));
        this.registerModelOverride(ModBlocks.ARCANE_CRYSTAL_OBELISK, base -> new FullbrightBakedModel((BakedModel)base, new ResourceLocation("forbidden_arcanus", "block/arcane_crystal_obelisk_lower_layer"), new ResourceLocation("forbidden_arcanus", "block/arcane_crystal_obelisk_middle"), new ResourceLocation("forbidden_arcanus", "block/arcane_crystal_obelisk_upper"), new ResourceLocation("forbidden_arcanus", "block/arcane_crystal_obelisk_top")));
        this.registerModelOverride(ModBlocks.HEPHAESTUS_FORGE, base -> new FullbrightBakedModel((BakedModel)base, new ResourceLocation("forbidden_arcanus", "block/hephaestus_forge_side_layer"), new ResourceLocation("forbidden_arcanus", "block/hephaestus_forge_top_layer")));
        ItemProperties.register((Item)((Item)ModItems.SPECTRAL_EYE_AMULET.get()), (ResourceLocation)new ResourceLocation("deactivated"), (stack, world, entity, seed) -> {
            SpectralEyeAmuletItem item;
            Item patt6832$temp;
            return entity != null && (patt6832$temp = stack.m_41720_()) instanceof SpectralEyeAmuletItem && (item = (SpectralEyeAmuletItem)patt6832$temp).isDeactivated(stack) ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)((Item)ModItems.OBSIDIAN_SKULL_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)ModItems.UTREM_JAR.get()), (ResourceLocation)new ResourceLocation("water"), (stack, world, entity, seed) -> {
            UtremJarItem item;
            Item patt7277$temp = stack.m_41720_();
            return patt7277$temp instanceof UtremJarItem && (item = (UtremJarItem)patt7277$temp).getFluid(stack) == Fluids.f_76193_ ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)((Item)ModItems.UTREM_JAR.get()), (ResourceLocation)new ResourceLocation("lava"), (stack, world, entity, seed) -> {
            UtremJarItem item;
            Item patt7499$temp = stack.m_41720_();
            return patt7499$temp instanceof UtremJarItem && (item = (UtremJarItem)patt7499$temp).getFluid(stack) == Fluids.f_76195_ ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)((Item)ModItems.BLOOD_TEST_TUBE.get()), (ResourceLocation)new ResourceLocation("amount"), (stack, world, entity, seed) -> (float)BloodTestTubeItem.getBlood(stack) / 3000.0f);
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT, (String)"Flight Timer", (IIngameOverlay)new FlightTimerOverlay());
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT, (String)"Sanity Meter", (IIngameOverlay)new SanityMeterOverlay());
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT, (String)"Obsidian Skull", (IIngameOverlay)new ObsidianSkullOverlay());
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        FullbrightBakedModel.invalidateCache();
        for (Triple<Block, StatePropertiesPredicate, Function<BakedModel, BakedModel>> triple : this.bakedModelOverrideRegistry) {
            ((Block)triple.getLeft()).m_49965_().m_61056_().stream().filter(state -> ((StatePropertiesPredicate)triple.getMiddle()).m_67667_(state)).map(BlockModelShaper::m_110895_).forEach(modelResourceLocation -> modelRegistry.put(modelResourceLocation, (BakedModel)((Function)triple.getRight()).apply((BakedModel)modelRegistry.get(modelResourceLocation))));
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        ResourceLocation textureLocation = event.getAtlas().m_118330_();
        if (textureLocation.equals((Object)TextureAtlas.f_118259_)) {
            event.addSprite(new ResourceLocation("forbidden_arcanus", "entity/obsidian_skull_shield"));
        }
    }

    private <T extends Block> void registerModelOverride(RegistryObject<T> block, Function<BakedModel, BakedModel> function) {
        this.registerModelOverride(block, StatePropertiesPredicate.f_67658_, function);
    }

    private <T extends Block> void registerModelOverride(RegistryObject<T> block, StatePropertiesPredicate predicate, Function<BakedModel, BakedModel> function) {
        this.bakedModelOverrideRegistry.add((Triple<Block, StatePropertiesPredicate, Function<BakedModel, BakedModel>>)Triple.of((Object)((Block)block.get()), (Object)predicate, function));
    }
}

