/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.inventory.ControllerInventoryHandler;
import com.buuz135.functionalstorage.inventory.ILockable;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class DrawerControllerTile
extends ControllableDrawerTile<DrawerControllerTile> {
    private static HashMap<UUID, Long> INTERACTION_LOGGER = new HashMap();
    @Save
    private ConnectedDrawers connectedDrawers = new ConnectedDrawers(null);
    public ControllerInventoryHandler handler = new ControllerInventoryHandler(){

        @Override
        public ConnectedDrawers getDrawers() {
            return DrawerControllerTile.this.connectedDrawers;
        }
    };
    private LazyOptional<IItemHandler> lazyStorage = LazyOptional.of(() -> this.handler);

    public DrawerControllerTile(BasicTileBlock<DrawerControllerTile> base, BlockEntityType<DrawerControllerTile> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    @Override
    public int getStorageSlotAmount() {
        return 1;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, DrawerControllerTile blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (this.connectedDrawers.getConnectedDrawers().size() != this.connectedDrawers.getHandlers().size()) {
            this.connectedDrawers.getConnectedDrawers().removeIf(aLong -> !(this.m_58904_().m_7702_(BlockPos.m_122022_((long)aLong)) instanceof ControllableDrawerTile));
            this.connectedDrawers.setLevel(this.m_58904_());
            this.connectedDrawers.rebuild();
            this.markForUpdate();
            this.updateNeigh();
        }
    }

    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41720_().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.m_41720_().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (this.isServer()) {
            int slot;
            for (IItemHandler iItemHandler : this.getConnectedDrawers().handlers) {
                if (!(iItemHandler instanceof ILockable) || !((ILockable)iItemHandler).isLocked()) continue;
                for (slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                    if (!stack.m_41619_() && iItemHandler.insertItem(slot, stack, true).m_41613_() != stack.m_41613_()) {
                        playerIn.m_21008_(hand, iItemHandler.insertItem(slot, stack, false));
                        return InteractionResult.SUCCESS;
                    }
                    if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.m_142081_(), System.currentTimeMillis()) >= 300L) continue;
                    for (ItemStack itemStack : playerIn.m_150109_().f_35974_) {
                        if (itemStack.m_41619_() || iItemHandler.insertItem(slot, itemStack, true).m_41613_() == itemStack.m_41613_()) continue;
                        itemStack.m_41764_(iItemHandler.insertItem(slot, itemStack.m_41777_(), false).m_41613_());
                    }
                }
            }
            for (IItemHandler iItemHandler : this.getConnectedDrawers().handlers) {
                if (!(iItemHandler instanceof ILockable) || ((ILockable)iItemHandler).isLocked()) continue;
                for (slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                    if (!stack.m_41619_() && !iItemHandler.getStackInSlot(slot).m_41619_() && iItemHandler.insertItem(slot, stack, true).m_41613_() != stack.m_41613_()) {
                        playerIn.m_21008_(hand, iItemHandler.insertItem(slot, stack, false));
                        return InteractionResult.SUCCESS;
                    }
                    if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.m_142081_(), System.currentTimeMillis()) >= 300L) continue;
                    for (ItemStack itemStack : playerIn.m_150109_().f_35974_) {
                        if (itemStack.m_41619_() || iItemHandler.getStackInSlot(slot).m_41619_() || iItemHandler.insertItem(slot, itemStack, true).m_41613_() == itemStack.m_41613_()) continue;
                        itemStack.m_41764_(iItemHandler.insertItem(slot, itemStack.m_41777_(), false).m_41613_());
                    }
                }
            }
            INTERACTION_LOGGER.put(playerIn.m_142081_(), System.currentTimeMillis());
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public IItemHandler getStorage() {
        return this.handler;
    }

    @Override
    public LazyOptional<IItemHandler> getOptional() {
        return this.lazyStorage;
    }

    @Override
    public int getBaseSize(int lost) {
        return 1;
    }

    @Override
    public void toggleLocking() {
        super.toggleLocking();
        if (this.isServer()) {
            for (Long connectedDrawer : new ArrayList<Long>(this.connectedDrawers.getConnectedDrawers())) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(BlockPos.m_122022_((long)connectedDrawer));
                if (blockEntity instanceof DrawerControllerTile || !(blockEntity instanceof ControllableDrawerTile)) continue;
                ((ControllableDrawerTile)blockEntity).setLocked(this.isLocked());
            }
        }
    }

    @Override
    public void toggleOption(ConfigurationToolItem.ConfigurationAction action) {
        super.toggleOption(action);
        if (this.isServer()) {
            for (Long connectedDrawer : new ArrayList<Long>(this.connectedDrawers.getConnectedDrawers())) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(BlockPos.m_122022_((long)connectedDrawer));
                if (blockEntity instanceof DrawerControllerTile || !(blockEntity instanceof ControllableDrawerTile)) continue;
                ((ControllableDrawerTile)blockEntity).getDrawerOptions().setActive(action, this.getDrawerOptions().isActive(action));
                ((ControllableDrawerTile)blockEntity).markForUpdate();
            }
        }
    }

    @NotNull
    public DrawerControllerTile getSelf() {
        return this;
    }

    public ConnectedDrawers getConnectedDrawers() {
        return this.connectedDrawers;
    }

    public void addConnectedDrawers(LinkingToolItem.ActionMode action, BlockPos ... positions) {
        AABB area = new AABB(this.m_58899_()).m_82400_((double)FunctionalStorageConfig.DRAWER_CONTROLLER_LINKING_RANGE);
        for (BlockPos position : positions) {
            BlockEntity blockEntity;
            if (this.f_58857_.m_8055_(position).m_60713_((Block)((RegistryObject)FunctionalStorage.DRAWER_CONTROLLER.getLeft()).get())) continue;
            if (area.m_82390_(Vec3.m_82512_((Vec3i)position)) && (blockEntity = this.m_58904_().m_7702_(position)) instanceof ControllableDrawerTile) {
                ControllableDrawerTile controllableDrawerTile = (ControllableDrawerTile)blockEntity;
                if (action == LinkingToolItem.ActionMode.ADD) {
                    controllableDrawerTile.setControllerPos(this.m_58899_());
                    if (!this.connectedDrawers.getConnectedDrawers().contains(position.m_121878_())) {
                        this.connectedDrawers.getConnectedDrawers().add(position.m_121878_());
                    }
                }
            }
            if (action != LinkingToolItem.ActionMode.REMOVE) continue;
            this.connectedDrawers.getConnectedDrawers().removeIf(aLong -> aLong.longValue() == position.m_121878_());
        }
        this.connectedDrawers.rebuild();
        this.markForUpdate();
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(50.0);
    }

    public class ConnectedDrawers
    implements INBTSerializable<CompoundTag> {
        private List<Long> connectedDrawers = new ArrayList<Long>();
        private List<IItemHandler> handlers = new ArrayList<IItemHandler>();
        private Level level;

        public ConnectedDrawers(Level level) {
            this.level = level;
        }

        public void setLevel(Level level) {
            this.level = level;
        }

        public void rebuild() {
            this.handlers = new ArrayList<IItemHandler>();
            if (this.level != null && !this.level.m_5776_()) {
                for (Long connectedDrawer : this.connectedDrawers) {
                    BlockPos pos = BlockPos.m_122022_((long)connectedDrawer);
                    BlockEntity entity = this.level.m_7702_(pos);
                    if (entity instanceof DrawerControllerTile || !(entity instanceof ControllableDrawerTile)) continue;
                    this.handlers.add(((ControllableDrawerTile)entity).getStorage());
                }
            }
            DrawerControllerTile.this.handler.invalidateSlots();
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            for (int i = 0; i < this.connectedDrawers.size(); ++i) {
                compoundTag.m_128356_("" + i, this.connectedDrawers.get(i).longValue());
            }
            return compoundTag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.connectedDrawers = new ArrayList<Long>();
            for (String allKey : nbt.m_128431_()) {
                this.connectedDrawers.add(nbt.m_128454_(allKey));
            }
            this.rebuild();
        }

        public List<Long> getConnectedDrawers() {
            return this.connectedDrawers;
        }

        public List<IItemHandler> getHandlers() {
            return this.handlers;
        }
    }
}

