/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.tile.DrawerControllerTile;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public abstract class ControllableDrawerTile<T extends ControllableDrawerTile<T>>
extends ActiveTile<T> {
    private static HashMap<UUID, Long> INTERACTION_LOGGER = new HashMap();
    private boolean needsUpgradeCache = true;
    @Save
    private BlockPos controllerPos;
    @Save
    private InventoryComponent<ControllableDrawerTile<T>> storageUpgrades;
    @Save
    private InventoryComponent<ControllableDrawerTile<T>> utilityUpgrades;
    @Save
    private DrawerOptions drawerOptions = new DrawerOptions();
    @Save
    private boolean hasDowngrade = false;
    @Save
    private boolean isCreative = false;
    @Save
    private boolean isVoid = false;
    @Save
    private int mult = 1;

    public ControllableDrawerTile(BasicTileBlock<T> base, BlockEntityType<T> entityType, BlockPos pos, BlockState state) {
        super(base, entityType, pos, state);
        this.storageUpgrades = new InventoryComponent<ControllableDrawerTile<T>>("storage_upgrades", 10, 70, this.getStorageSlotAmount()){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack stack = this.getStackInSlot(slot);
                if (stack.m_41720_() instanceof StorageUpgradeItem) {
                    int i;
                    int mult = 1;
                    for (i = 0; i < ControllableDrawerTile.this.storageUpgrades.getSlots(); ++i) {
                        if (!(ControllableDrawerTile.this.storageUpgrades.getStackInSlot(i).m_41720_() instanceof StorageUpgradeItem) || i == slot) continue;
                        if (mult == 1) {
                            mult = ((StorageUpgradeItem)ControllableDrawerTile.this.storageUpgrades.getStackInSlot(i).m_41720_()).getStorageMultiplier();
                            continue;
                        }
                        mult *= ((StorageUpgradeItem)ControllableDrawerTile.this.storageUpgrades.getStackInSlot(i).m_41720_()).getStorageMultiplier();
                    }
                    for (i = 0; i < ControllableDrawerTile.this.getStorage().getSlots(); ++i) {
                        if (ControllableDrawerTile.this.getBaseSize(i) * mult >= ControllableDrawerTile.this.getStorage().getStackInSlot(i).m_41613_()) continue;
                        return ItemStack.f_41583_;
                    }
                }
                return super.extractItem(slot, amount, simulate);
            }
        }.setInputFilter((stack, integer) -> {
            if (stack.m_41720_().equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                for (int i = 0; i < this.getStorage().getSlots(); ++i) {
                    if (this.getStorage().getStackInSlot(i).m_41613_() <= 64) continue;
                    return false;
                }
            }
            return stack.m_41720_() instanceof UpgradeItem && ((UpgradeItem)stack.m_41720_()).getType() == UpgradeItem.Type.STORAGE;
        }).setOnSlotChanged((stack, integer) -> {
            this.needsUpgradeCache = true;
        }).setSlotLimit(1);
        if (this.getStorageSlotAmount() > 0) {
            this.addInventory(this.storageUpgrades);
        }
        this.utilityUpgrades = new InventoryComponent("utility_upgrades", 114, 70, 3).setInputFilter((stack, integer) -> stack.m_41720_() instanceof UpgradeItem && ((UpgradeItem)stack.m_41720_()).getType() == UpgradeItem.Type.UTILITY).setSlotLimit(1).setOnSlotChanged((itemStack, integer) -> {
            BlockEntity patt5833$temp;
            this.needsUpgradeCache = true;
            if (this.controllerPos != null && (patt5833$temp = this.f_58857_.m_7702_(this.controllerPos)) instanceof DrawerControllerTile) {
                DrawerControllerTile controllerTile = (DrawerControllerTile)patt5833$temp;
                controllerTile.getConnectedDrawers().rebuild();
            }
        });
        this.addInventory(this.utilityUpgrades);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        if (this.getStorageSlotAmount() > 0) {
            this.addGuiAddonFactory(() -> new TextScreenAddon("Storage", 10, 59, false, ChatFormatting.DARK_GRAY.m_126665_()){

                public String getText() {
                    return new TranslatableComponent("key.categories.storage").getString();
                }
            });
        }
        this.addGuiAddonFactory(() -> new TextScreenAddon("Utility", 114, 59, false, ChatFormatting.DARK_GRAY.m_126665_()){

            public String getText() {
                return new TranslatableComponent("key.categories.utility").getString();
            }
        });
        this.addGuiAddonFactory(() -> new TextScreenAddon("key.categories.inventory", 8, 92, false, ChatFormatting.DARK_GRAY.m_126665_()){

            public String getText() {
                return new TranslatableComponent("key.categories.inventory").getString();
            }
        });
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        Item item;
        ItemStack stack;
        int i;
        super.serverTick(level, pos, state, blockEntity);
        if (level.m_46467_() % 20L == 0L) {
            for (i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                stack = this.utilityUpgrades.getStackInSlot(i);
                if (stack.m_41619_() || !(item = stack.m_41720_()).equals(FunctionalStorage.REDSTONE_UPGRADE.get())) continue;
                level.m_46672_(this.m_58899_(), (Block)this.getBasicTileBlock());
                break;
            }
        }
        if (level.m_46467_() % 4L == 0L) {
            block1: for (i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                Direction direction;
                stack = this.utilityUpgrades.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                item = stack.m_41720_();
                if (item.equals(FunctionalStorage.PULLING_UPGRADE.get())) {
                    direction = UpgradeItem.getDirection(stack);
                    TileUtil.getTileEntity((BlockGetter)level, (BlockPos)pos.m_142300_(direction)).ifPresent(blockEntity1 -> blockEntity1.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).ifPresent(iItemHandler -> {
                        for (int otherSlot = 0; otherSlot < iItemHandler.getSlots(); ++otherSlot) {
                            ItemStack pulledStack = iItemHandler.extractItem(otherSlot, 2, true);
                            if (pulledStack.m_41619_()) continue;
                            boolean hasWorked = false;
                            for (int ourSlot = 0; ourSlot < this.getStorage().getSlots(); ++ourSlot) {
                                ItemStack simulated = this.getStorage().insertItem(ourSlot, pulledStack, true);
                                if (simulated.m_41613_() == pulledStack.m_41613_()) continue;
                                this.getStorage().insertItem(ourSlot, iItemHandler.extractItem(otherSlot, pulledStack.m_41613_() - simulated.m_41613_(), false), false);
                                hasWorked = true;
                                break;
                            }
                            if (hasWorked) break;
                        }
                    }));
                }
                if (item.equals(FunctionalStorage.PUSHING_UPGRADE.get())) {
                    direction = UpgradeItem.getDirection(stack);
                    TileUtil.getTileEntity((BlockGetter)level, (BlockPos)pos.m_142300_(direction)).ifPresent(blockEntity1 -> blockEntity1.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).ifPresent(otherHandler -> {
                        for (int otherSlot = 0; otherSlot < this.getStorage().getSlots(); ++otherSlot) {
                            ItemStack pulledStack = this.getStorage().extractItem(otherSlot, 2, true);
                            if (pulledStack.m_41619_()) continue;
                            boolean hasWorked = false;
                            for (int ourSlot = 0; ourSlot < otherHandler.getSlots(); ++ourSlot) {
                                ItemStack simulated = otherHandler.insertItem(ourSlot, pulledStack, true);
                                if (simulated.m_41613_() == pulledStack.m_41613_()) continue;
                                otherHandler.insertItem(ourSlot, this.getStorage().extractItem(otherSlot, pulledStack.m_41613_() - simulated.m_41613_(), false), false);
                                hasWorked = true;
                                break;
                            }
                            if (hasWorked) break;
                        }
                    }));
                }
                if (!item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get())) continue;
                direction = UpgradeItem.getDirection(stack);
                AABB box = new AABB(pos.m_142300_(direction));
                for (ItemEntity entitiesOfClass : level.m_45976_(ItemEntity.class, box)) {
                    ItemStack pulledStack = ItemHandlerHelper.copyStackWithSize((ItemStack)entitiesOfClass.m_32055_(), (int)Math.min(entitiesOfClass.m_32055_().m_41613_(), 4));
                    if (pulledStack.m_41619_()) continue;
                    boolean hasWorked = false;
                    for (int ourSlot = 0; ourSlot < this.getStorage().getSlots(); ++ourSlot) {
                        ItemStack simulated = this.getStorage().insertItem(ourSlot, pulledStack, true);
                        if (simulated.m_41613_() == pulledStack.m_41613_()) continue;
                        this.getStorage().insertItem(ourSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)entitiesOfClass.m_32055_(), (int)(pulledStack.m_41613_() - simulated.m_41613_())), false);
                        entitiesOfClass.m_32055_().m_41774_(pulledStack.m_41613_() - simulated.m_41613_());
                        hasWorked = true;
                        break;
                    }
                    if (!hasWorked) continue;
                    continue block1;
                }
            }
        }
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public void setControllerPos(BlockPos controllerPos) {
        if (this.controllerPos != null) {
            TileUtil.getTileEntity((BlockGetter)this.m_58904_(), (BlockPos)this.controllerPos, DrawerControllerTile.class).ifPresent(drawerControllerTile -> drawerControllerTile.addConnectedDrawers(LinkingToolItem.ActionMode.REMOVE, this.m_58899_()));
        }
        this.controllerPos = controllerPos;
    }

    public int getStorageMultiplier() {
        this.maybeCacheUpgrades();
        return this.mult;
    }

    public boolean isVoid() {
        this.maybeCacheUpgrades();
        return this.isVoid;
    }

    public boolean isCreative() {
        this.maybeCacheUpgrades();
        return this.isCreative;
    }

    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        Item item;
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41720_().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.m_41720_().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            if (upgradeItem instanceof StorageUpgradeItem) {
                StorageUpgradeItem storageUpgradeItem = (StorageUpgradeItem)upgradeItem;
                component = this.storageUpgrades;
                for (i = 0; i < component.getSlots(); ++i) {
                    if (!component.getStackInSlot(i).m_41619_()) continue;
                    playerIn.m_21008_(hand, component.insertItem(i, stack, false));
                    return InteractionResult.SUCCESS;
                }
                for (i = 0; i < component.getSlots(); ++i) {
                    StorageUpgradeItem instertedUpgrade;
                    Item item2;
                    if (component.getStackInSlot(i).m_41619_() || !((item2 = component.getStackInSlot(i).m_41720_()) instanceof StorageUpgradeItem) || (instertedUpgrade = (StorageUpgradeItem)item2).getStorageMultiplier() >= storageUpgradeItem.getStorageMultiplier()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)component.getStackInSlot(i).m_41777_());
                    component.setStackInSlot(i, ItemStack.f_41583_);
                    playerIn.m_21008_(hand, component.insertItem(i, stack, false));
                    return InteractionResult.SUCCESS;
                }
            } else {
                component = this.utilityUpgrades;
                for (i = 0; i < component.getSlots(); ++i) {
                    if (!component.getStackInSlot(i).m_41619_()) continue;
                    playerIn.m_21008_(hand, component.insertItem(i, stack, false));
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (slot == -1) {
            this.openGui(playerIn);
        } else if (this.isServer()) {
            if (!stack.m_41619_() && this.getStorage().insertItem(slot, stack, true).m_41613_() != stack.m_41613_()) {
                playerIn.m_21008_(hand, this.getStorage().insertItem(slot, stack, false));
                return InteractionResult.SUCCESS;
            }
            if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.m_142081_(), System.currentTimeMillis()) < 300L) {
                for (ItemStack itemStack : playerIn.m_150109_().f_35974_) {
                    if (itemStack.m_41619_() || this.getStorage().insertItem(slot, itemStack, true).m_41613_() == itemStack.m_41613_()) continue;
                    itemStack.m_41764_(this.getStorage().insertItem(slot, itemStack.m_41777_(), false).m_41613_());
                }
            }
            INTERACTION_LOGGER.put(playerIn.m_142081_(), System.currentTimeMillis());
        }
        return InteractionResult.SUCCESS;
    }

    public abstract int getStorageSlotAmount();

    public void onClicked(Player playerIn, int slot) {
        BlockHitResult blockResult;
        Direction facing;
        HitResult rayTraceResult;
        if (this.isServer() && slot != -1 && (rayTraceResult = RayTraceUtils.rayTraceSimple((Level)this.f_58857_, (LivingEntity)playerIn, (double)16.0, (float)0.0f)).m_6662_() == HitResult.Type.BLOCK && (facing = (blockResult = (BlockHitResult)rayTraceResult).m_82434_()).equals((Object)this.getFacingDirection())) {
            ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)this.getStorage().extractItem(slot, playerIn.m_6144_() ? this.getStorage().getStackInSlot(slot).m_41741_() : 1, false));
        }
    }

    public abstract IItemHandler getStorage();

    public abstract LazyOptional<IItemHandler> getOptional();

    public abstract int getBaseSize(int var1);

    private void maybeCacheUpgrades() {
        if (this.needsUpgradeCache) {
            int i;
            this.isCreative = false;
            this.hasDowngrade = false;
            this.mult = 1;
            for (i = 0; i < this.storageUpgrades.getSlots(); ++i) {
                Item upgrade = this.storageUpgrades.getStackInSlot(i).m_41720_();
                if (upgrade.equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                    this.hasDowngrade = true;
                }
                if (upgrade.equals(FunctionalStorage.CREATIVE_UPGRADE.get())) {
                    this.isCreative = true;
                }
                if (!(upgrade instanceof StorageUpgradeItem)) continue;
                this.mult *= ((StorageUpgradeItem)upgrade).getStorageMultiplier();
            }
            this.isVoid = false;
            for (i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                if (!this.utilityUpgrades.getStackInSlot(i).m_41720_().equals(FunctionalStorage.VOID_UPGRADE.get())) continue;
                this.isVoid = true;
            }
            this.needsUpgradeCache = false;
        }
    }

    public boolean hasDowngrade() {
        this.maybeCacheUpgrades();
        return this.hasDowngrade;
    }

    public void toggleLocking() {
        this.setLocked(!this.isLocked());
    }

    public boolean isLocked() {
        return this.m_58900_().m_61138_((Property)DrawerBlock.LOCKED) && (Boolean)this.m_58900_().m_61143_((Property)DrawerBlock.LOCKED) != false;
    }

    public void setLocked(boolean locked) {
        if (this.m_58900_().m_61138_((Property)DrawerBlock.LOCKED)) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(locked)), 3);
        }
    }

    public void toggleOption(ConfigurationToolItem.ConfigurationAction action) {
        this.drawerOptions.setActive(action, !this.drawerOptions.isActive(action));
        this.markForUpdate();
    }

    public DrawerOptions getDrawerOptions() {
        return this.drawerOptions;
    }

    public InventoryComponent<ControllableDrawerTile<T>> getUtilityUpgrades() {
        return this.utilityUpgrades;
    }

    public InventoryComponent<ControllableDrawerTile<T>> getStorageUpgrades() {
        return this.storageUpgrades;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.getOptional().invalidate();
    }

    public boolean isEverythingEmpty() {
        int i;
        for (i = 0; i < this.getStorage().getSlots(); ++i) {
            if (this.getStorage().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static class DrawerOptions
    implements INBTSerializable<CompoundTag> {
        public HashMap<ConfigurationToolItem.ConfigurationAction, Boolean> options = new HashMap();

        public DrawerOptions() {
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_NUMBERS, true);
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_RENDER, true);
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_UPGRADES, true);
        }

        public boolean isActive(ConfigurationToolItem.ConfigurationAction configurationAction) {
            return this.options.getOrDefault((Object)configurationAction, true);
        }

        public void setActive(ConfigurationToolItem.ConfigurationAction configurationAction, boolean active) {
            this.options.put(configurationAction, active);
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            for (ConfigurationToolItem.ConfigurationAction action : this.options.keySet()) {
                compoundTag.m_128379_(action.name(), this.options.get((Object)action).booleanValue());
            }
            return compoundTag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            for (String allKey : nbt.m_128431_()) {
                this.options.put(ConfigurationToolItem.ConfigurationAction.valueOf(allKey), nbt.m_128471_(allKey));
            }
        }
    }
}

