/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor;

import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.EdBreaker;
import wile.engineersdecor.blocks.EdChair;
import wile.engineersdecor.blocks.EdCraftingTable;
import wile.engineersdecor.blocks.EdDropper;
import wile.engineersdecor.blocks.EdElectricalFurnace;
import wile.engineersdecor.blocks.EdFluidBarrel;
import wile.engineersdecor.blocks.EdFluidFunnel;
import wile.engineersdecor.blocks.EdFreezer;
import wile.engineersdecor.blocks.EdFurnace;
import wile.engineersdecor.blocks.EdHopper;
import wile.engineersdecor.blocks.EdLabeledCrate;
import wile.engineersdecor.blocks.EdLadderBlock;
import wile.engineersdecor.blocks.EdMilker;
import wile.engineersdecor.blocks.EdMineralSmelter;
import wile.engineersdecor.blocks.EdPipeValve;
import wile.engineersdecor.blocks.EdPlacer;
import wile.engineersdecor.blocks.EdSolarPanel;
import wile.engineersdecor.blocks.EdTreeCutter;
import wile.engineersdecor.blocks.EdWasteIncinerator;
import wile.engineersdecor.libmc.blocks.SlabSliceBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.VariantSlabBlock;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.OptionalRecipeCondition;

public class ModConfig {
    private static final String MODID = "engineersdecor";
    public static final CommonConfig COMMON;
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    public static final ForgeConfigSpec SERVER_CONFIG_SPEC;
    private static final CompoundTag server_config_;
    private static HashSet<String> optouts_;
    private static boolean with_experimental_features_;
    private static boolean with_config_logging_;
    private static boolean with_debug_logs_;
    public static boolean immersiveengineering_installed;
    public static boolean without_direct_slab_pickup;
    public static boolean with_creative_mode_device_drops;

    public static boolean isOptedOut(@Nullable Block block) {
        return block == null || ModConfig.isOptedOut(block.m_5456_());
    }

    public static boolean isOptedOut(@Nullable Item item) {
        return item != null && optouts_.contains(item.getRegistryName().m_135815_());
    }

    public static boolean withExperimental() {
        return with_experimental_features_;
    }

    public static boolean withoutRecipes() {
        return false;
    }

    public static boolean withDebug() {
        return with_debug_logs_;
    }

    public static boolean withDebugLogging() {
        return with_experimental_features_ && with_config_logging_;
    }

    public static CompoundTag getServerConfig() {
        return server_config_;
    }

    private static void updateOptouts() {
        int i;
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        String inc = ((String)ModConfig.COMMON.pattern_includes.get()).toLowerCase().replaceAll("engineersdecor:", "").replaceAll("[^*_,a-z0-9]", "");
        if (!((String)ModConfig.COMMON.pattern_includes.get()).equals(inc)) {
            ModConfig.COMMON.pattern_includes.set((Object)inc);
        }
        String[] incl = inc.split(",");
        for (i = 0; i < incl.length; ++i) {
            incl[i] = incl[i].replaceAll("[*]", ".*?");
            if (incl[i].isEmpty()) continue;
            includes.add(incl[i]);
        }
        String exc = ((String)ModConfig.COMMON.pattern_excludes.get()).toLowerCase().replaceAll("engineersdecor:", "").replaceAll("[^*_,a-z0-9]", "");
        String[] excl = exc.split(",");
        for (i = 0; i < excl.length; ++i) {
            excl[i] = excl[i].replaceAll("[*]", ".*?");
            if (excl[i].isEmpty()) continue;
            excludes.add(excl[i]);
        }
        if (!excludes.isEmpty()) {
            ModConfig.log("Config pattern excludes: '" + String.join((CharSequence)",", excludes) + "'");
        }
        if (!includes.isEmpty()) {
            ModConfig.log("Config pattern includes: '" + String.join((CharSequence)",", includes) + "'");
        }
        HashSet optouts = new HashSet();
        ModContent.getRegisteredBlocks().stream().filter(block -> {
            if (block == null) {
                return true;
            }
            if (block == ModContent.getBlock("sign_decor")) {
                return true;
            }
            try {
                if (!with_experimental_features_) {
                    if (block instanceof Auxiliaries.IExperimentalFeature) {
                        return true;
                    }
                    if (ModContent.isExperimentalBlock(block)) {
                        return true;
                    }
                }
                if (!immersiveengineering_installed && block instanceof StandardBlocks.IStandardBlock && (((StandardBlocks.IStandardBlock)block).config() & Long.MIN_VALUE) != 0L) {
                    return true;
                }
                String rn = block.getRegistryName().m_135815_();
                try {
                    for (String e : includes) {
                        if (!rn.matches(e)) continue;
                        ModConfig.log("Optout force include: " + rn);
                        return false;
                    }
                    for (String e : excludes) {
                        if (!rn.matches(e)) continue;
                        ModConfig.log("Optout force exclude: " + rn);
                        return true;
                    }
                }
                catch (Throwable ex) {
                    Auxiliaries.logger().error("optout include pattern failed, disabling.");
                    includes.clear();
                    excludes.clear();
                }
            }
            catch (Exception ex) {
                Auxiliaries.logger().error("Exception evaluating the optout config: '" + ex.getMessage() + "'");
            }
            return false;
        }).forEach(e -> optouts.add(e.getRegistryName().m_135815_()));
        optouts_ = optouts;
        OptionalRecipeCondition.on_config(ModConfig.withExperimental(), ModConfig.withoutRecipes(), ModConfig::isOptedOut, ModConfig::isOptedOut);
    }

    public static void apply() {
        with_config_logging_ = (Boolean)ModConfig.COMMON.with_config_logging.get();
        with_experimental_features_ = (Boolean)ModConfig.COMMON.with_experimental.get();
        with_debug_logs_ = (Boolean)ModConfig.COMMON.with_debug_logging.get();
        if (with_experimental_features_) {
            Auxiliaries.logger().info("Config: EXPERIMENTAL FEATURES ENABLED.");
        }
        if (with_debug_logs_) {
            Auxiliaries.logger().info("Config: DEBUG LOGGING ENABLED, WARNING, THIS MAY SPAM THE LOG.");
        }
        immersiveengineering_installed = Auxiliaries.isModLoaded("immersiveengineering");
        ModConfig.updateOptouts();
        if (!SERVER_CONFIG_SPEC.isLoaded()) {
            return;
        }
        without_direct_slab_pickup = (Boolean)ModConfig.SERVER.without_direct_slab_pickup.get();
        EdChair.on_config((Boolean)ModConfig.SERVER.without_chair_sitting.get(), (Boolean)ModConfig.SERVER.without_mob_chair_sitting.get(), (Double)ModConfig.SERVER.chair_mob_sitting_probability_percent.get(), (Double)ModConfig.SERVER.chair_mob_standup_probability_percent.get());
        EdLadderBlock.on_config((Boolean)ModConfig.SERVER.without_ladder_speed_boost.get());
        VariantSlabBlock.on_config((Boolean)ModConfig.SERVER.without_direct_slab_pickup.get() == false);
        SlabSliceBlock.on_config((Boolean)ModConfig.SERVER.without_direct_slab_pickup.get() == false);
        EdLabeledCrate.on_config(false);
        EdCraftingTable.on_config((Boolean)ModConfig.SERVER.without_crafting_table_history.get(), false, (Boolean)ModConfig.SERVER.without_crafting_mouse_scrolling.get());
        EdFluidBarrel.on_config(12000, 1000);
        EdFluidFunnel.on_config(with_experimental_features_);
        EdPipeValve.on_config((Integer)ModConfig.SERVER.pipevalve_max_flowrate.get(), (Integer)ModConfig.SERVER.pipevalve_redstone_gain.get());
        EdHopper.on_config();
        EdDropper.on_config(true);
        EdPlacer.on_config();
        EdBreaker.on_config((Integer)ModConfig.SERVER.block_breaker_power_consumption.get(), (Integer)ModConfig.SERVER.block_breaker_reluctance.get(), (Integer)ModConfig.SERVER.block_breaker_min_breaking_time.get(), (Boolean)ModConfig.SERVER.block_breaker_requires_power.get());
        EdTreeCutter.on_config((Integer)ModConfig.SERVER.tree_cutter_energy_consumption.get(), (Integer)ModConfig.SERVER.tree_cutter_cutting_time_needed.get(), (Boolean)ModConfig.SERVER.tree_cutter_requires_power.get());
        EdFurnace.on_config((Integer)ModConfig.SERVER.furnace_smelting_speed_percent.get(), (Integer)ModConfig.SERVER.furnace_fuel_efficiency_percent.get(), (Integer)ModConfig.SERVER.furnace_boost_energy_consumption.get(), (String)ModConfig.SERVER.furnace_accepted_heaters.get());
        EdElectricalFurnace.on_config((Integer)ModConfig.SERVER.e_furnace_speed_percent.get(), (Integer)ModConfig.SERVER.e_furnace_power_consumption.get(), (Boolean)ModConfig.SERVER.e_furnace_automatic_pulling.get());
        EdSolarPanel.on_config((Integer)ModConfig.SERVER.small_solar_panel_peak_production.get(), 64000, 1024);
        EdMilker.on_config((Integer)ModConfig.SERVER.milking_machine_energy_consumption.get(), (Integer)ModConfig.SERVER.milking_machine_milking_delay.get());
        EdFreezer.on_config(144, 2);
        EdMineralSmelter.on_config(144, 2);
        EdWasteIncinerator.on_config(8);
        server_config_.m_128379_("tree_cutter_requires_power", ((Boolean)ModConfig.SERVER.tree_cutter_requires_power.get()).booleanValue());
        server_config_.m_128379_("block_breaker_requires_power", ((Boolean)ModConfig.SERVER.block_breaker_requires_power.get()).booleanValue());
        String s = String.join((CharSequence)",", optouts_);
        server_config_.m_128359_("optout", s);
        if (!s.isEmpty()) {
            ModConfig.log("Opt-outs:" + s);
        }
    }

    public static void log(String config_message) {
        if (!with_config_logging_) {
            return;
        }
        Auxiliaries.logger().info(config_message);
    }

    static {
        Pair common_ = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)common_.getRight();
        COMMON = (CommonConfig)common_.getLeft();
        Pair server_ = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)server_.getRight();
        SERVER = (ServerConfig)server_.getLeft();
        server_config_ = new CompoundTag();
        optouts_ = new HashSet();
        with_experimental_features_ = false;
        with_config_logging_ = false;
        with_debug_logs_ = false;
        immersiveengineering_installed = false;
        without_direct_slab_pickup = false;
        with_creative_mode_device_drops = false;
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<String> pattern_excludes;
        public final ForgeConfigSpec.ConfigValue<String> pattern_includes;
        public final ForgeConfigSpec.BooleanValue with_creative_mode_device_drops;
        public final ForgeConfigSpec.BooleanValue with_experimental;
        public final ForgeConfigSpec.BooleanValue with_config_logging;
        public final ForgeConfigSpec.BooleanValue with_debug_logging;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side.").push("server");
            builder.comment("Opt-out settings").push("optout");
            this.pattern_excludes = builder.translation("engineersdecor.config.pattern_excludes").comment("Opt-out any block by its registry name ('*' wildcard matching, comma separated list, whitespaces ignored. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' excludes everything that has 'wood' or 'steel' in the registry name. The matching result is also traced in the log file. ").define("pattern_excludes", (Object)"");
            this.pattern_includes = builder.translation("engineersdecor.config.pattern_includes").comment("Prevent blocks from being opt'ed by registry name ('*' wildcard matching, comma separated list, whitespaces ignored. Evaluated before all other opt-out checks. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' includes everything that has 'wood' or 'steel' in the registry name.The matching result is also traced in the log file.").define("pattern_includes", (Object)"");
            builder.pop();
            builder.comment("Miscellaneous settings").push("miscellaneous");
            this.with_experimental = builder.translation("engineersdecor.config.with_experimental").comment("Enables experimental features. Use at own risk.").define("with_experimental", false);
            this.with_creative_mode_device_drops = builder.translation("engineersdecor.config.with_creative_mode_device_drops").comment("Enable that devices are dropped as item also in creative mode, allowing  to relocate them with contents and settings.").define("with_creative_mode_device_drops", false);
            this.with_config_logging = builder.translation("engineersdecor.config.with_debug_logging").comment("Enable detailed logging of the config values and resulting calculations in each mod feature config.").define("with_debug_logging", false);
            this.with_debug_logging = builder.translation("engineersdecor.config.with_debug_logging").comment("Enable debug log messages for trouble shooting. Don't activate if not really needed, this can spam the log file.").define("with_debug_logging", false);
            builder.pop();
        }
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.BooleanValue without_chair_sitting;
        public final ForgeConfigSpec.BooleanValue without_mob_chair_sitting;
        public final ForgeConfigSpec.BooleanValue without_ladder_speed_boost;
        public final ForgeConfigSpec.BooleanValue without_crafting_table_history;
        public final ForgeConfigSpec.BooleanValue without_direct_slab_pickup;
        public final ForgeConfigSpec.IntValue furnace_smelting_speed_percent;
        public final ForgeConfigSpec.IntValue furnace_fuel_efficiency_percent;
        public final ForgeConfigSpec.IntValue furnace_boost_energy_consumption;
        public final ForgeConfigSpec.ConfigValue<String> furnace_accepted_heaters;
        public final ForgeConfigSpec.IntValue e_furnace_speed_percent;
        public final ForgeConfigSpec.IntValue e_furnace_power_consumption;
        public final ForgeConfigSpec.IntValue small_solar_panel_peak_production;
        public final ForgeConfigSpec.BooleanValue e_furnace_automatic_pulling;
        public final ForgeConfigSpec.DoubleValue chair_mob_sitting_probability_percent;
        public final ForgeConfigSpec.DoubleValue chair_mob_standup_probability_percent;
        public final ForgeConfigSpec.BooleanValue without_crafting_mouse_scrolling;
        public final ForgeConfigSpec.IntValue pipevalve_max_flowrate;
        public final ForgeConfigSpec.IntValue pipevalve_redstone_gain;
        public final ForgeConfigSpec.IntValue block_breaker_power_consumption;
        public final ForgeConfigSpec.IntValue block_breaker_reluctance;
        public final ForgeConfigSpec.IntValue block_breaker_min_breaking_time;
        public final ForgeConfigSpec.BooleanValue block_breaker_requires_power;
        public final ForgeConfigSpec.IntValue tree_cutter_energy_consumption;
        public final ForgeConfigSpec.IntValue tree_cutter_cutting_time_needed;
        public final ForgeConfigSpec.BooleanValue tree_cutter_requires_power;
        public final ForgeConfigSpec.IntValue milking_machine_energy_consumption;
        public final ForgeConfigSpec.IntValue milking_machine_milking_delay;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side.").push("server");
            builder.comment("Server dev opt-out settings !WARNING THE OPT-OUTs will be moved to common-config.toml in the next MC version!").push("optout");
            this.without_chair_sitting = builder.translation("engineersdecor.config.without_chair_sitting").comment("Disable possibility to sit on stools and chairs.").define("without_chair_sitting", false);
            this.without_mob_chair_sitting = builder.translation("engineersdecor.config.without_mob_chair_sitting").comment("Disable that mobs will sit on chairs and stools.").define("without_mob_chair_sitting", false);
            this.without_ladder_speed_boost = builder.translation("engineersdecor.config.without_ladder_speed_boost").comment("Disable the speed boost of ladders in this mod.").define("without_ladder_speed_boost", false);
            this.without_crafting_table_history = builder.translation("engineersdecor.config.without_crafting_table_history").comment("Disable history refabrication feature of the crafting table.").define("without_crafting_table_history", false);
            builder.pop();
            builder.comment("Miscellaneous settings").push("miscellaneous");
            this.without_direct_slab_pickup = builder.translation("engineersdecor.config.without_direct_slab_pickup").comment("Disable directly picking up layers from slabs and slab  slices by left clicking while looking up/down.").define("without_direct_slab_pickup", false);
            builder.pop();
            builder.comment("Tweaks").push("tweaks");
            this.furnace_smelting_speed_percent = builder.translation("engineersdecor.config.furnace_smelting_speed_percent").comment("Defines, in percent, how fast the lab furnace smelts compared to a vanilla furnace. 100% means vanilla furnace speed, 150% means the lab furnace is faster. The value can be changed on-the-fly for tuning.").defineInRange("furnace_smelting_speed_percent", 130, 50, 800);
            this.furnace_fuel_efficiency_percent = builder.translation("engineersdecor.config.furnace_fuel_efficiency_percent").comment("Defines, in percent, how fuel efficient the lab furnace is, compared to a vanilla furnace. 100% means vanilla furnace consumiton, 200% means the lab furnace needs about half the fuel of a vanilla furnace, The value can be changed on-the-fly for tuning.").defineInRange("furnace_fuel_efficiency_percent", 100, 50, 400);
            this.furnace_boost_energy_consumption = builder.translation("engineersdecor.config.furnace_boost_energy_consumption").comment("Defines the energy consumption (per tick) for speeding up the smelting process. If IE is installed, an external heater has to be inserted into an auxiliary slot of the lab furnace. The power source needs to be able to provide at least 4 times this consumption (fixed threshold value). The value can be changed on-the-fly for tuning. The default value corresponds to the IE heater consumption.").defineInRange("furnace_boost_energy_consumption", 24, 2, 1024);
            this.furnace_accepted_heaters = builder.translation("engineersdecor.config.furnace_accepted_heaters").comment("Defines (as comma separated list of full registry names) which items are allowed as external heaters in the Aux slot for powered speed boosting.").define("furnace_accepted_heaters", (Object)"immersiveengineering:furnace_heater");
            this.chair_mob_sitting_probability_percent = builder.translation("engineersdecor.config.chair_mob_sitting_probability_percent").comment("Defines, in percent, how high the probability is that a mob sits on a chair when colliding with it. Can be changed on-the-fly for tuning.").defineInRange("chair_mob_sitting_probability_percent", 10.0, 0.0, 80.0);
            this.chair_mob_standup_probability_percent = builder.translation("engineersdecor.config.chair_mob_standup_probability_percent").comment("Defines, in percent, probable it is that a mob leaves a chair when sitting on it. The 'dice is rolled' about every 20 ticks. There is also a minimum Sitting time of about 3s. The config value can be changed on-the-fly for tuning.").defineInRange("chair_mob_standup_probability_percent", 1.0, 0.001, 10.0);
            this.without_crafting_mouse_scrolling = builder.translation("engineersdecor.config.without_crafting_mouse_scrolling").comment("Disables increasing/decreasing the crafting grid items by scrolling over the crafting result slot.").define("without_crafting_mouse_scrolling", false);
            this.pipevalve_max_flowrate = builder.translation("engineersdecor.config.pipevalve_max_flowrate").comment("Defines how many millibuckets can be transferred (per tick) through the valves. That is technically the 'storage size' specified for blocks that want to fill fluids into the valve (the valve has no container and forward that to the output block), The value can be changed on-the-fly for tuning. ").defineInRange("pipevalve_max_flowrate", 1000, 1, 32000);
            this.pipevalve_redstone_gain = builder.translation("engineersdecor.config.pipevalve_redstone_gain").comment("Defines how many millibuckets per redstone signal strength can be transferred per tick through the analog redstone controlled valves. Note: power 0 is always off, power 15 is always the max flow rate. Between power 1 and 14 this scaler will result in a flow = 'redstone slope' * 'current redstone power'. The value can be changed on-the-fly for tuning. ").defineInRange("pipevalve_redstone_gain", 20, 1, 32000);
            this.e_furnace_speed_percent = builder.translation("engineersdecor.config.e_furnace_speed_percent").comment("Defines, in percent, how fast the electrical furnace smelts compared to a vanilla furnace. 100% means vanilla furnace speed, 150% means the electrical furnace is faster. The value can be changed on-the-fly for tuning.").defineInRange("e_furnace_speed_percent", 290, 50, 800);
            this.e_furnace_power_consumption = builder.translation("engineersdecor.config.e_furnace_power_consumption").comment("Defines how much RF per tick the the electrical furnace consumed (average) for smelting. The feeders transferring items from/to adjacent have this consumption/8 for each stack transaction. The default value is only slightly higher than a furnace with an IE external heater (and no burning fuel inside).The config value can be changed on-the-fly for tuning.").defineInRange("e_furnace_power_consumption", 16, 8, 4096);
            this.e_furnace_automatic_pulling = builder.translation("engineersdecor.config.e_furnace_automatic_pulling").comment("Defines if the electrical furnace automatically pulls items from an inventory at the input side.The config value can be changed on-the-fly for tuning.").define("e_furnace_automatic_pulling", false);
            this.small_solar_panel_peak_production = builder.translation("engineersdecor.config.small_solar_panel_peak_production").comment("Defines the peak power production (at noon) of the Small Solar Panel. Note that the agerage power is much less, as no power is produced at all during the night, and the power curve is nonlinear rising/falling during the day. Bad weather conditions also decrease the production. The config value can be changed on-the-fly for tuning.").defineInRange("small_solar_panel_peak_production", 40, 2, 4096);
            this.block_breaker_power_consumption = builder.translation("engineersdecor.config.block_breaker_power_consumption").comment("Defines how much RF power the Small Block Breaker requires to magnificently increase the processing speed. The config value can be changed on-the-fly for tuning.").defineInRange("block_breaker_power_consumption", 64, 4, 1024);
            this.block_breaker_reluctance = builder.translation("engineersdecor.config.block_breaker_reluctance").comment("Defines how much time the Small Block Breaker needs per block hardness, means: 'reluctance' * hardness + min_time, you change the 'reluctance' here.The unit is ticks/hardness. The config value can be changed on-the-fly for tuning.").defineInRange("block_breaker_reluctance", 17, 5, 50);
            this.block_breaker_min_breaking_time = builder.translation("engineersdecor.config.block_breaker_min_breaking_time").comment("Defines how much time the Small Block Breaker needs at least, better said it's an offset: 'reluctance' * hardness + min_time, you change the 'min_time' here, value in ticks.The config value can be changed on-the-fly for tuning.").defineInRange("block_breaker_min_breaking_time", 15, 10, 100);
            this.block_breaker_requires_power = builder.translation("engineersdecor.config.block_breaker_requires_power").comment("Defines if the Small Block Breaker does not work without RF power.").define("block_breaker_requires_power", false);
            this.tree_cutter_energy_consumption = builder.translation("engineersdecor.config.tree_cutter_energy_consumption").comment("Defines how much RF power the Small Tree Cutter requires to magnificently increase the processing speed. The config value can be changed on-the-fly for tuning.").defineInRange("tree_cutter_energy_consumption", 64, 4, 1024);
            this.tree_cutter_cutting_time_needed = builder.translation("engineersdecor.config.tree_cutter_cutting_time_needed").comment("Defines how much time the Small Tree Cutter needs to cut a tree without RF power. The value is in seconds. With energy it is 6 times faster. The config value can be changed on-the-fly for tuning.").defineInRange("tree_cutter_cutting_time_needed", 60, 10, 240);
            this.tree_cutter_requires_power = builder.translation("engineersdecor.config.tree_cutter_requires_power").comment("Defines if the Small Tree Cutter does not work without RF power.").define("tree_cutter_requires_power", false);
            this.milking_machine_energy_consumption = builder.translation("engineersdecor.config.milking_machine_energy_consumption").comment("Defines how much time the Small Milking Machine needs work. Note this is a permanent standby power, not only when the device does something. Use zero to disable energy dependency and energy handling of the machine. The config value can be changed on-the-fly for tuning.").defineInRange("milking_machine_energy_consumption", 0, 0, 1024);
            this.milking_machine_milking_delay = builder.translation("engineersdecor.config.milking_machine_milking_delay").comment("Defines (for each individual cow) the minimum time between milking.").defineInRange("milking_machine_milking_delay", 4000, 1000, 24000);
            builder.pop();
        }
    }
}

