/*
 * Decompiled with CFR 0.152.
 */
package com.denismasterherobrine.angelring.compat;

import com.denismasterherobrine.angelring.register.ItemRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosCompat {
    public static void sendImc() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("angelring").build());
    }

    public static ICapabilityProvider initCapabilities() {
        final ICurio curio = new ICurio(){

            public ItemStack getStack() {
                return ItemRegistry.ItemRing.m_7968_();
            }

            public boolean canEquipFromUse(SlotContext slotContext) {
                return true;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    this.startFlying(player);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    this.stopFlying(player);
                }
            }

            private void startFlying(Player player) {
                if (!player.m_7500_() && !player.m_5833_()) {
                    player.m_150110_().f_35936_ = true;
                    player.m_6885_();
                }
            }

            private void stopFlying(Player player) {
                if (!player.m_7500_() && !player.m_5833_()) {
                    player.m_150110_().f_35935_ = false;
                    player.m_150110_().f_35936_ = false;
                    player.m_6885_();
                }
            }

            public void curioTick(SlotContext slotContext) {
                LivingEntity entity = slotContext.entity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!player.m_150110_().f_35936_) {
                        this.startFlying(player);
                    }
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return !CuriosApi.getCuriosHelper().findEquippedCurio(ItemRegistry.ItemRing, slotContext.entity()).isPresent();
            }

            public void onEquipFromUse(SlotContext slotContext) {
                slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
            }

            @Nonnull
            public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
                return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
            }
        };
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }
}

