/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature.structure;

import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.world.feature.config.IElementTypeFeatureConfig;
import sirttas.elementalcraft.world.feature.structure.ECStructures;

public class SourceAltarStructure
extends StructureFeature<IElementTypeFeatureConfig> {
    public static final String NAME = "source_altar";

    public SourceAltarStructure() {
        super(IElementTypeFeatureConfig.CODEC, PieceGeneratorSupplier.m_197349_((Predicate)PieceGeneratorSupplier.m_197345_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG), SourceAltarStructure::generatePieces));
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<IElementTypeFeatureConfig> context) {
        WorldgenRandom random = context.f_192708_();
        builder.m_142679_((StructurePiece)new Piece(context.f_192704_(), SourceAltarStructure.getRoll((Random)random), new BlockPos(context.f_192705_().m_45604_(), 90, context.f_192705_().m_45605_()), ((IElementTypeFeatureConfig)context.f_197328_()).getElementType((Random)random)));
    }

    private static ResourceLocation getRoll(Random random) {
        int roll = random.nextInt(20);
        if (roll == 0) {
            return ElementalCraft.createRL("altar/chapel");
        }
        if (roll <= 3) {
            return ElementalCraft.createRL("altar/medium");
        }
        return ElementalCraft.createRL("altar/small");
    }

    @Nonnull
    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ElementType elementType;

        public Piece(StructureManager manager, ResourceLocation templateName, BlockPos pos, ElementType elementType) {
            super((StructurePieceType)ECStructures.SOURCE_ALTAR_PIECE_TYPE, 0, manager, templateName, templateName.toString(), Piece.makeSettings(templateName), pos);
            this.elementType = elementType;
        }

        public Piece(StructureManager manager, CompoundTag tag) {
            super((StructurePieceType)ECStructures.SOURCE_ALTAR_PIECE_TYPE, tag, manager, Piece::makeSettings);
            this.elementType = ElementType.byName(tag.m_128461_("ElementType"));
        }

        private static StructurePlaceSettings makeSettings(ResourceLocation id) {
            return new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74385_(new BlockPos(1, 0, 1)).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        protected void m_183620_(@Nonnull StructurePieceSerializationContext context, @Nonnull CompoundTag tag) {
            super.m_183620_(context, tag);
            tag.m_128359_("ElementType", this.elementType.m_7912_());
        }

        public void m_183269_(WorldGenLevel level, @Nonnull StructureFeatureManager structureManager, @Nonnull ChunkGenerator chunkGenerator, @Nonnull Random random, @Nonnull BoundingBox boundingBox, @Nonnull ChunkPos chunkPos, @Nonnull BlockPos pos) {
            this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, this.f_73658_.m_123341_(), this.f_73658_.m_123343_()) - 1, this.f_73658_.m_123343_());
            super.m_183269_(level, structureManager, chunkGenerator, random, boundingBox, chunkPos, pos);
        }

        protected void m_7756_(String function, @Nonnull BlockPos pos, @Nonnull ServerLevelAccessor worldIn, @Nonnull Random rand, @Nonnull BoundingBox sbb) {
            if (function.endsWith("chest")) {
                this.m_73420_(worldIn, sbb, rand, pos, ElementalCraft.createRL("chests/altar/" + this.getChestType(function) + "_" + this.elementType.m_7912_()), null);
                worldIn.m_6289_(pos, Blocks.f_50087_);
            } else if ("source".equals(function)) {
                worldIn.m_7731_(pos, (BlockState)((Block)ECBlocks.SOURCE.get()).m_49966_().m_61124_(ElementType.STATE_PROPERTY, (Comparable)((Object)this.elementType)), 3);
            }
        }

        private String getChestType(String function) {
            String[] split = function.split("_");
            return split.length > 1 ? split[0] : "small";
        }
    }
}

