/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature.structure;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.registry.RegistryHelper;
import sirttas.elementalcraft.world.feature.config.IElementTypeFeatureConfig;
import sirttas.elementalcraft.world.feature.structure.SourceAltarStructure;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECStructures {
    public static final StructureFeature<IElementTypeFeatureConfig> SOURCE_ALTAR = new SourceAltarStructure();
    public static final StructurePieceType.StructureTemplateType SOURCE_ALTAR_PIECE_TYPE = ECStructures.get(SourceAltarStructure.Piece::new);

    private ECStructures() {
    }

    @SubscribeEvent
    public static void registerStructures(RegistryEvent.Register<StructureFeature<?>> event) {
        IForgeRegistry r = event.getRegistry();
        ECStructures.register(r, SOURCE_ALTAR, SOURCE_ALTAR_PIECE_TYPE, "source_altar");
    }

    private static void register(IForgeRegistry<StructureFeature<?>> reg, StructureFeature<?> thing, StructurePieceType.StructureTemplateType pieceType, String name) {
        ECStructures.register(reg, thing, name);
        ECStructures.registerPiece(pieceType, name);
    }

    private static void register(IForgeRegistry<StructureFeature<?>> reg, StructureFeature<?> thing, String name) {
        RegistryHelper.register(reg, thing, ElementalCraft.createRL(name));
    }

    private static void registerPiece(StructurePieceType.StructureTemplateType pieceType, String name) {
        ECStructures.registerPiece(pieceType, ElementalCraft.createRL(name));
    }

    private static void registerPiece(StructurePieceType.StructureTemplateType pieceType, ResourceLocation location) {
        Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)location, (Object)pieceType);
    }

    private static StructurePieceType.StructureTemplateType get(StructurePieceType.StructureTemplateType type) {
        return type;
    }
}

