/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.data.worldgen.StructureSets;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.registry.RegistryHelper;
import sirttas.elementalcraft.tag.ECTags;
import sirttas.elementalcraft.world.feature.SourceFeature;
import sirttas.elementalcraft.world.feature.config.ElementTypeFeatureConfig;
import sirttas.elementalcraft.world.feature.config.IElementTypeFeatureConfig;
import sirttas.elementalcraft.world.feature.config.RandomElementTypeFeatureConfig;
import sirttas.elementalcraft.world.feature.placement.ECPlacements;
import sirttas.elementalcraft.world.feature.placement.SourcePlacement;
import sirttas.elementalcraft.world.feature.structure.ECStructures;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECFeatures {
    @ObjectHolder(value="elementalcraft:source")
    public static final Feature<IElementTypeFeatureConfig> SOURCE = null;
    private static Holder<PlacedFeature> crystalOrePlaced;
    private static Holder<PlacedFeature> sourcePlaced;
    private static Holder<PlacedFeature> icySourcePlaced;
    private static Holder<PlacedFeature> jungleSourcePlaced;
    private static Holder<PlacedFeature> mushroomSourcePlaced;
    private static Holder<PlacedFeature> netherSourcePlaced;
    private static Holder<PlacedFeature> wetSourcePlaced;
    private static Holder<PlacedFeature> drySourcePlaced;
    private static Holder<PlacedFeature> endSourcePlaced;
    private static Holder<PlacedFeature> forestSourcePlaced;
    private static Holder<PlacedFeature> hillSourcePlaced;
    private static Holder<PlacedFeature> mountainSourcePlaced;
    private static Holder<PlacedFeature> plainSourcePlaced;
    private static Holder<PlacedFeature> oceanSourcePlaced;

    private ECFeatures() {
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        ECFeatures.registerPlacement("source", ECPlacements.SOURCE);
        IForgeRegistry r = event.getRegistry();
        SourceFeature source = new SourceFeature();
        List<OreConfiguration.TargetBlockState> oreInertCrystalTargetList = List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)ECBlocks.CRYSTAL_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)ECBlocks.DEEPSLATE_CRYSTAL_ORE.get()).m_49966_()));
        List<PlacementModifier> chanceSourcePlacement = ECFeatures.sourcePlacement(new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)ECConfig.COMMON.sourceSpawnChance.get()))});
        RegistryHelper.register(r, source, "source");
        Holder<ConfiguredFeature<?, ?>> crystalOreConfig = ECFeatures.register("crystal_ore", Feature.f_65731_, new OreConfiguration(oreInertCrystalTargetList, ((Integer)ECConfig.COMMON.inertCrystalSize.get()).intValue()));
        crystalOrePlaced = ECFeatures.register("crystal_ore_middle", crystalOreConfig, OrePlacements.m_195343_((int)((Integer)ECConfig.COMMON.inertCrystalCount.get()), (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-24), (VerticalAnchor)VerticalAnchor.m_158922_((int)((Integer)ECConfig.COMMON.inertCrystalYMax.get())))));
        Holder<ConfiguredFeature<?, ?>> sourceConfig = ECFeatures.register("source", source, RandomElementTypeFeatureConfig.ALL);
        sourcePlaced = ECFeatures.register("source", sourceConfig, ECFeatures.sourcePlacement(new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)ECConfig.COMMON.randomSourceSpawnChance.get()))}));
        Holder<ConfiguredFeature<?, ?>> icySourceConfig = ECFeatures.register("source_icy", source, RandomElementTypeFeatureConfig.ICY);
        icySourcePlaced = ECFeatures.register("source_icy", icySourceConfig, chanceSourcePlacement);
        Holder<ConfiguredFeature<?, ?>> jungleSourceConfig = ECFeatures.register("source_jungle", source, RandomElementTypeFeatureConfig.JUNGLE);
        jungleSourcePlaced = ECFeatures.register("source_jungle", jungleSourceConfig, chanceSourcePlacement);
        Holder<ConfiguredFeature<?, ?>> mushroomSourceConfig = ECFeatures.register("source_mushroom", source, RandomElementTypeFeatureConfig.ALL);
        mushroomSourcePlaced = ECFeatures.register("source_mushroom", mushroomSourceConfig, chanceSourcePlacement);
        Holder<ConfiguredFeature<?, ?>> wetSourceConfig = ECFeatures.register("source_wet", source, RandomElementTypeFeatureConfig.WET);
        wetSourcePlaced = ECFeatures.register("source_wet", wetSourceConfig, chanceSourcePlacement);
        Holder<ConfiguredFeature<?, ?>> drySourceConfig = ECFeatures.register("source_dry", source, RandomElementTypeFeatureConfig.DRY);
        drySourcePlaced = ECFeatures.register("source_dry", drySourceConfig, chanceSourcePlacement);
        Holder<ConfiguredFeature<?, ?>> endSourceConfig = ECFeatures.register("source_end", source, RandomElementTypeFeatureConfig.END);
        endSourcePlaced = ECFeatures.register("source_end", endSourceConfig, chanceSourcePlacement);
        Holder<ConfiguredFeature<?, ?>> forestSourceConfig = ECFeatures.register("source_forest", source, RandomElementTypeFeatureConfig.FOREST);
        forestSourcePlaced = ECFeatures.register("source_forest", forestSourceConfig, chanceSourcePlacement);
        Holder<ConfiguredFeature<?, ?>> hillSourceConfig = ECFeatures.register("source_hill", source, RandomElementTypeFeatureConfig.HILL);
        hillSourcePlaced = ECFeatures.register("source_hill", hillSourceConfig, chanceSourcePlacement);
        Holder<ConfiguredFeature<?, ?>> mountainSourceConfig = ECFeatures.register("source_mountain", source, RandomElementTypeFeatureConfig.MOUNTAIN);
        mountainSourcePlaced = ECFeatures.register("source_mountain", mountainSourceConfig, chanceSourcePlacement);
        Holder<ConfiguredFeature<?, ?>> plainSourceConfig = ECFeatures.register("source_plain", source, RandomElementTypeFeatureConfig.PLAIN);
        plainSourcePlaced = ECFeatures.register("source_plain", plainSourceConfig, chanceSourcePlacement);
        Holder<ConfiguredFeature<?, ?>> netherSourceConfig = ECFeatures.register("source_nether", source, RandomElementTypeFeatureConfig.NETHER);
        netherSourcePlaced = ECFeatures.register("source_nether", netherSourceConfig, chanceSourcePlacement);
        Holder<ConfiguredFeature<?, ?>> oceanSourceConfig = ECFeatures.register("source_ocean", source, ElementTypeFeatureConfig.WATER);
        oceanSourcePlaced = ECFeatures.register("source_ocean", oceanSourceConfig, ECFeatures.sourcePlacement(new PlacementModifier[]{RarityFilter.m_191900_((int)((Integer)ECConfig.COMMON.oceanSourceSpawnChance.get()))}));
        ECFeatures.registerStructure("source_altar", ECStructures.SOURCE_ALTAR.m_209762_((FeatureConfiguration)RandomElementTypeFeatureConfig.ALL, ECTags.Biomes.HAS_SOURCE_ALTAR), (StructurePlacement)new RandomSpreadStructurePlacement(((Integer)ECConfig.COMMON.sourceAltarDistance.get()).intValue(), 8, RandomSpreadType.LINEAR, 4847339));
    }

    private static List<PlacementModifier> sourcePlacement(PlacementModifier ... modifiers) {
        ArrayList list = Lists.newArrayList((Object[])new PlacementModifier[]{new SourcePlacement(), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()});
        if (modifiers != null && modifiers.length > 0) {
            list.addAll(Arrays.asList(modifiers));
        }
        return List.copyOf(list);
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (Boolean.FALSE.equals(ECConfig.COMMON.disableWorldGen.get())) {
            BiomeGenerationSettingsBuilder generation = event.getGeneration();
            Biome.BiomeCategory category = event.getCategory();
            boolean sourceSpawn = Boolean.FALSE.equals(ECConfig.COMMON.disableSourceSpawn.get());
            if (Boolean.FALSE.equals(ECConfig.COMMON.disableInertCrystal.get()) && category != Biome.BiomeCategory.THEEND && category != Biome.BiomeCategory.NETHER) {
                generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, crystalOrePlaced);
            }
            if (sourceSpawn) {
                generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, sourcePlaced);
                switch (category) {
                    case ICY: {
                        generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, icySourcePlaced);
                        break;
                    }
                    case JUNGLE: {
                        generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, jungleSourcePlaced);
                        break;
                    }
                    case MUSHROOM: {
                        generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, mushroomSourcePlaced);
                        break;
                    }
                    case NETHER: {
                        generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, netherSourcePlaced);
                        break;
                    }
                    case OCEAN: {
                        generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, oceanSourcePlaced);
                        break;
                    }
                    case EXTREME_HILLS: {
                        generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, hillSourcePlaced);
                        break;
                    }
                    case MOUNTAIN: {
                        generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, mountainSourcePlaced);
                        break;
                    }
                    case PLAINS: {
                        generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, plainSourcePlaced);
                        break;
                    }
                    case BEACH: 
                    case RIVER: 
                    case SWAMP: {
                        generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, wetSourcePlaced);
                        break;
                    }
                    case TAIGA: 
                    case FOREST: {
                        generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, forestSourcePlaced);
                        break;
                    }
                    case MESA: 
                    case DESERT: 
                    case SAVANNA: {
                        generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, drySourcePlaced);
                        break;
                    }
                    case THEEND: {
                        generation.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, endSourcePlaced);
                    }
                }
            }
        }
    }

    public static void addSpawnSources(ServerLevel world) {
        if (Boolean.FALSE.equals(ECConfig.COMMON.disableSourceSpawn.get())) {
            Random rand = new Random(world.m_7328_());
            BlockPos pos = world.m_8900_().m_142082_(-100, 0, -100);
            for (ElementType type : ElementType.ALL_VALID) {
                for (int i = 0; i < (Integer)ECConfig.COMMON.sourceSpawnCount.get(); ++i) {
                    ECFeatures.addSpawnSource(world, pos.m_142082_(rand.nextInt(100), 0, rand.nextInt(100)), type);
                }
            }
        }
    }

    private static void addSpawnSource(ServerLevel level, BlockPos pos, ElementType type) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        int y = SourcePlacement.getHeight((LevelAccessor)level, x, z);
        ChunkPos chunkPos = new ChunkPos(pos);
        ServerChunkCache chunkProvider = level.m_7726_();
        chunkProvider.m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, true);
        level.m_7731_(new BlockPos(x, y, z), (BlockState)((Block)ECBlocks.SOURCE.get()).m_49966_().m_61124_(ElementType.STATE_PROPERTY, (Comparable)((Object)type)), 3);
    }

    public static <C extends FeatureConfiguration, F extends Feature<C>> Holder<ConfiguredFeature<?, ?>> register(String name, F feature, C config) {
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)ElementalCraft.createRL(name), (Object)new ConfiguredFeature(feature, config));
    }

    public static Holder<PlacedFeature> register(String name, Holder<? extends ConfiguredFeature<?, ?>> config, List<PlacementModifier> placement) {
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)ElementalCraft.createRL(name), (Object)new PlacedFeature(Holder.m_205706_(config), List.copyOf(placement)));
    }

    private static <C extends FeatureConfiguration> Holder<ConfiguredStructureFeature<?, ?>> registerStructure(String name, ConfiguredStructureFeature<C, ? extends StructureFeature<C>> structure, StructurePlacement structurePlacement) {
        ResourceLocation location = ElementalCraft.createRL(name);
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)location);
        ResourceKey setKey = ResourceKey.m_135785_((ResourceKey)Registry.f_211073_, (ResourceLocation)location);
        Holder configuredStructureFeatureHolder = StructureFeatures.m_211106_((ResourceKey)key, structure);
        StructureSets.m_211128_((ResourceKey)setKey, (StructureSet)new StructureSet(configuredStructureFeatureHolder, structurePlacement));
        return configuredStructureFeatureHolder;
    }

    private static <P extends PlacementModifier> PlacementModifierType<P> registerPlacement(String name, PlacementModifierType<P> pPlacementModifierType) {
        return (PlacementModifierType)Registry.m_122965_((Registry)Registry.f_194570_, (ResourceLocation)ElementalCraft.createRL(name), pPlacementModifierType);
    }
}

