/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.EmptyElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.StaticElementStorage;

public class WorldElementStorage
implements IElementStorage,
INBTSerializable<CompoundTag> {
    private final SubStorage fire;
    private final SubStorage water;
    private final SubStorage earth;
    private final SubStorage air;

    private WorldElementStorage() {
        this(new SubStorage(ElementType.FIRE), new SubStorage(ElementType.WATER), new SubStorage(ElementType.EARTH), new SubStorage(ElementType.AIR));
    }

    private WorldElementStorage(SubStorage fire, SubStorage water, SubStorage earth, SubStorage air) {
        this.fire = fire;
        this.water = water;
        this.earth = earth;
        this.air = air;
    }

    public static ICapabilityProvider createProvider() {
        return CapabilityElementStorage.createProvider(new WorldElementStorage());
    }

    @Override
    public int getElementAmount(ElementType type) {
        return this.getSubStorage(type).getElementAmount(type);
    }

    @Override
    public int getElementCapacity(ElementType type) {
        return this.getSubStorage(type).getElementCapacity(type);
    }

    @Override
    public int insertElement(int count, ElementType type, boolean simulate) {
        return this.getSubStorage(type).insertElement(count, type, simulate);
    }

    @Override
    public int extractElement(int count, ElementType type, boolean simulate) {
        return this.getSubStorage(type).extractElement(count, type, simulate);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(ElementType.FIRE.m_7912_(), (Tag)this.fire.serializeNBT());
        compound.m_128365_(ElementType.WATER.m_7912_(), (Tag)this.water.serializeNBT());
        compound.m_128365_(ElementType.EARTH.m_7912_(), (Tag)this.earth.serializeNBT());
        compound.m_128365_(ElementType.AIR.m_7912_(), (Tag)this.air.serializeNBT());
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.fire.deserializeNBT(compound.m_128469_(ElementType.FIRE.m_7912_()));
        this.water.deserializeNBT(compound.m_128469_(ElementType.WATER.m_7912_()));
        this.earth.deserializeNBT(compound.m_128469_(ElementType.EARTH.m_7912_()));
        this.air.deserializeNBT(compound.m_128469_(ElementType.AIR.m_7912_()));
    }

    private IElementStorage getSubStorage(ElementType elementType) {
        return switch (elementType) {
            case ElementType.FIRE -> this.fire;
            case ElementType.AIR -> this.air;
            case ElementType.EARTH -> this.earth;
            case ElementType.WATER -> this.water;
            default -> EmptyElementStorage.INSTANCE;
        };
    }

    private static class SubStorage
    extends StaticElementStorage {
        public SubStorage(ElementType type, int elementAmount, int elementCapacity) {
            super(type, elementCapacity);
            this.elementAmount = elementAmount;
        }

        public SubStorage(ElementType type) {
            super(type, 1000000);
        }
    }
}

