/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.tag;

import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class ECTags {
    private ECTags() {
    }

    public static class Biomes {
        public static final TagKey<Biome> HAS_SOURCE_ALTAR = Biomes.createTag("has_structure/source_altar");

        private Biomes() {
        }

        private static TagKey<Biome> createTag(String name) {
            return Biomes.createTag("elementalcraft", name);
        }

        private static TagKey<Biome> createForgeTag(String name) {
            return Biomes.createTag("forge", name);
        }

        private static TagKey<Biome> createTag(String modId, String name) {
            return TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(modId, name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> LAVASHRINE_LIQUIFIABLES = Blocks.createTag("lavashrine_liquifiables");
        public static final TagKey<Block> GROWTHSHRINE_BLACKLIST = Blocks.createTag("growthshrine_blacklist");
        public static final TagKey<Block> SMALL_CONTAINER_COMPATIBLES = Blocks.createTag("small_container_compatibles");
        public static final TagKey<Block> PUREROCKS = Blocks.createTag("purerocks");
        public static final TagKey<Block> PIPES = Blocks.createTag("pipes");
        public static final TagKey<Block> SHRINES = Blocks.createTag("shrines");
        public static final TagKey<Block> SHRINE_UPGRADES = Blocks.createTag("shrine_upgrades");
        public static final TagKey<Block> INSTRUMENTS = Blocks.createTag("instruments");
        public static final TagKey<Block> CONTAINER_TOOLS = Blocks.createTag("container_tools");
        public static final TagKey<Block> PEDESTALS = Blocks.createTag("pedestals");
        public static final TagKey<Block> RUNE_AFFECTED = Blocks.createTag("rune_affected");
        public static final TagKey<Block> RUNE_AFFECTED_SPEED = Blocks.createTag("rune_affected/speed");
        public static final TagKey<Block> RUNE_AFFECTED_PRESERVATION = Blocks.createTag("rune_affected/preservation");
        public static final TagKey<Block> RUNE_AFFECTED_LUCK = Blocks.createTag("rune_affected/luck");
        public static final TagKey<Block> SHRINES_UPGRADABLES_ACCELERATION = Blocks.createTag("shrines/upgradables/acceleration");
        public static final TagKey<Block> SHRINES_UPGRADABLES_RANGE = Blocks.createTag("shrines/upgradables/range");
        public static final TagKey<Block> SHRINES_UPGRADABLES_STRENGTH = Blocks.createTag("shrines/upgradables/strength");
        public static final TagKey<Block> SHRINES_UPGRADABLES_PROTECTION = Blocks.createTag("shrines/upgradables/protection");
        public static final TagKey<Block> STORAGE_BLOCKS_DRENCHED_IRON = Blocks.createForgeTag("storage_blocks/drenched_iron");
        public static final TagKey<Block> STORAGE_BLOCKS_SWIFT_ALLOY = Blocks.createForgeTag("storage_blocks/swift_alloy");
        public static final TagKey<Block> STORAGE_BLOCKS_FIREITE = Blocks.createForgeTag("storage_blocks/fireite");
        public static final TagKey<Block> ORES_INERT_CRYSTAL = Blocks.createForgeTag("ores/inert_crystal");
        public static final TagKey<Block> BAG_OF_YURTING_BLACKLIST = Blocks.createTag("bagofyurting", "blacklist");

        private Blocks() {
        }

        private static TagKey<Block> createTag(String name) {
            return Blocks.createTag("elementalcraft", name);
        }

        private static TagKey<Block> createForgeTag(String name) {
            return Blocks.createTag("forge", name);
        }

        private static TagKey<Block> createTag(String modId, String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation(modId, name));
        }
    }

    public static class Items {
        public static final TagKey<Item> SPELL_CAST_TOOLS = Items.createTag("spell_cast_tools");
        public static final TagKey<Item> INFUSABLE_FOCUS = Items.createTag("infusable/focus");
        public static final TagKey<Item> INFUSABLE_STAVES = Items.createTag("infusable/staves");
        public static final TagKey<Item> INFUSABLE_SWORDS = Items.createTag("infusable/swords");
        public static final TagKey<Item> INFUSABLE_PICKAXES = Items.createTag("infusable/pickaxes");
        public static final TagKey<Item> INFUSABLE_AXES = Items.createTag("infusable/axes");
        public static final TagKey<Item> INFUSABLE_SHOVELS = Items.createTag("infusable/shovels");
        public static final TagKey<Item> INFUSABLE_HOES = Items.createTag("infusable/hoes");
        public static final TagKey<Item> INFUSABLE_SHILDS = Items.createTag("infusable/shields");
        public static final TagKey<Item> INFUSABLE_BOWS = Items.createTag("infusable/bows");
        public static final TagKey<Item> INFUSABLE_CROSSBOWS = Items.createTag("infusable/crossbows");
        public static final TagKey<Item> INFUSABLE_FISHING_RODS = Items.createTag("infusable/fishing_rods");
        public static final TagKey<Item> INFUSABLE_TRIDENTS = Items.createTag("infusable/tridents");
        public static final TagKey<Item> INFUSABLE_HELMETS = Items.createTag("infusable/helmets");
        public static final TagKey<Item> INFUSABLE_CHESTPLATES = Items.createTag("infusable/chestplates");
        public static final TagKey<Item> INFUSABLE_LEGGINGS = Items.createTag("infusable/leggings");
        public static final TagKey<Item> INFUSABLE_BOOTS = Items.createTag("infusable/boots");
        public static final TagKey<Item> SPELL_HOLDERS = Items.createTag("spell_holders");
        public static final TagKey<Item> ELEMENTAL_CRYSTALS = Items.createTag("crystals/elemental");
        public static final TagKey<Item> CRYSTALS = Items.createTag("crystals");
        public static final TagKey<Item> LENSES = Items.createTag("lenses");
        public static final TagKey<Item> SHARDS = Items.createTag("shards");
        public static final TagKey<Item> DEFAULT_SHARDS = Items.createTag("shards/default");
        public static final TagKey<Item> POWERFUL_SHARDS = Items.createTag("shards/powerful");
        public static final TagKey<Item> FIRE_SHARDS = Items.createTag("shards/fire");
        public static final TagKey<Item> WATER_SHARDS = Items.createTag("shards/water");
        public static final TagKey<Item> EARTH_SHARDS = Items.createTag("shards/earth");
        public static final TagKey<Item> AIR_SHARDS = Items.createTag("shards/air");
        public static final TagKey<Item> CRUDE_FIRE_GEMS = Items.createTag("gems/crude_fire");
        public static final TagKey<Item> CRUDE_WATER_GEMS = Items.createTag("gems/crude_water");
        public static final TagKey<Item> CRUDE_EARTH_GEMS = Items.createTag("gems/crude_earth");
        public static final TagKey<Item> CRUDE_AIR_GEMS = Items.createTag("gems/crude_air");
        public static final TagKey<Item> FINE_FIRE_GEMS = Items.createTag("gems/fine_fire");
        public static final TagKey<Item> FINE_WATER_GEMS = Items.createTag("gems/fine_water");
        public static final TagKey<Item> FINE_EARTH_GEMS = Items.createTag("gems/fine_earth");
        public static final TagKey<Item> FINE_AIR_GEMS = Items.createTag("gems/fine_air");
        public static final TagKey<Item> PRISTINE_FIRE_GEMS = Items.createTag("gems/pristine_fire");
        public static final TagKey<Item> PRISTINE_WATER_GEMS = Items.createTag("gems/pristine_water");
        public static final TagKey<Item> PRISTINE_EARTH_GEMS = Items.createTag("gems/pristine_earth");
        public static final TagKey<Item> PRISTINE_AIR_GEMS = Items.createTag("gems/pristine_air");
        public static final TagKey<Item> INPUT_FIRE_GEMS = Items.createTag("gems/input_fire");
        public static final TagKey<Item> INPUT_WATER_GEMS = Items.createTag("gems/input_water");
        public static final TagKey<Item> INPUT_EARTH_GEMS = Items.createTag("gems/input_earth");
        public static final TagKey<Item> INPUT_AIR_GEMS = Items.createTag("gems/input_air");
        public static final TagKey<Item> INPUT_GEMS = Items.createTag("gems/input");
        public static final TagKey<Item> RUNE_SLATES = Items.createTag("rune_slates");
        public static final TagKey<Item> PUREROCKS = Items.createTag("purerocks");
        public static final TagKey<Item> PIPES = Items.createTag("pipes");
        public static final TagKey<Item> SHRINES = Items.createTag("shrines");
        public static final TagKey<Item> SHRINE_UPGRADES = Items.createTag("shrine_upgrades");
        public static final TagKey<Item> SMALL_CONTAINER_COMPATIBLES = Items.createTag("small_container_compatibles");
        public static final TagKey<Item> INSTRUMENTS = Items.createTag("instruments");
        public static final TagKey<Item> CONTAINER_TOOLS = Items.createTag("container_tools");
        public static final TagKey<Item> PIPE_COVER_HIDING = Items.createTag("pipe_cover_hiding");
        public static final TagKey<Item> STAFF_CRAFT_SWORD = Items.createTag("staff_craft_sword");
        public static final TagKey<Item> PURE_ORES_ORE_SOURCE = Items.createTag("pure_ores/ore_source");
        public static final TagKey<Item> PURE_ORES_RAW_METAL_SOURCE = Items.createTag("pure_ores/raw_metas_source");
        public static final TagKey<Item> PURE_ORES_MOD_PROCESSING_BLACKLIST = Items.createTag("pure_ores/mod_processing_blacklist");
        public static final TagKey<Item> JEWEL_SOCKETABLES = Items.createTag("jewel_socketables");
        public static final TagKey<Item> RECEPTACLES = Items.createTag("receptacles");
        public static final TagKey<Item> RECEPTACLES_EMPTY = Items.createTag("receptacles/empty");
        public static final TagKey<Item> RECEPTACLES_FULL = Items.createTag("receptacles/full");
        public static final TagKey<Item> RECEPTACLES_IMPROVED = Items.createTag("receptacles/improved");
        public static final TagKey<Item> GROVE_SHRINE_FLOWERS = Items.createTag("grove_shrine_flowers");
        public static final TagKey<Item> GROVE_SHRINE_BLACKLIST = Items.createTag("grove_shrine_blacklist");
        public static final TagKey<Item> MYSTICAL_GROVE_FLOWERS = Items.createTag("mystical_grove_flowers");
        public static final TagKey<Item> FORGE_SWORDS = Items.createForgeTag("swords");
        public static final TagKey<Item> FORGE_PICKAXES = Items.createForgeTag("pickaxes");
        public static final TagKey<Item> FORGE_AXES = Items.createForgeTag("axes");
        public static final TagKey<Item> FORGE_SHOVELS = Items.createForgeTag("shovels");
        public static final TagKey<Item> FORGE_HOES = Items.createForgeTag("hoes");
        public static final TagKey<Item> FORGE_SHILDS = Items.createForgeTag("shields");
        public static final TagKey<Item> FORGE_BOWS = Items.createForgeTag("bows");
        public static final TagKey<Item> FORGE_CROSSBOWS = Items.createForgeTag("crossbows");
        public static final TagKey<Item> FORGE_HELMETS = Items.createForgeTag("helmets");
        public static final TagKey<Item> FORGE_CHESTPLATES = Items.createForgeTag("chestplates");
        public static final TagKey<Item> FORGE_LEGGINGS = Items.createForgeTag("leggings");
        public static final TagKey<Item> FORGE_BOOTS = Items.createForgeTag("boots");
        public static final TagKey<Item> INGOTS_MANASTEEL = Items.createTag("forge", "ingots/manasteel");
        public static final TagKey<Item> INGOTS_DRENCHED_IRON = Items.createForgeTag("ingots/drenched_iron");
        public static final TagKey<Item> INGOTS_SWIFT_ALLOY = Items.createForgeTag("ingots/swift_alloy");
        public static final TagKey<Item> INGOTS_FIREITE = Items.createForgeTag("ingots/fireite");
        public static final TagKey<Item> NUGGETS_DRENCHED_IRON = Items.createForgeTag("nuggets/drenched_iron");
        public static final TagKey<Item> NUGGETS_SWIFT_ALLOY = Items.createForgeTag("nuggets/swift_alloy");
        public static final TagKey<Item> NUGGETS_FIREITE = Items.createForgeTag("nuggets/fireite");
        public static final TagKey<Item> STORAGE_BLOCKS_DRENCHED_IRON = Items.createForgeTag("storage_blocks/drenched_iron");
        public static final TagKey<Item> STORAGE_BLOCKS_SWIFT_ALLOY = Items.createForgeTag("storage_blocks/swift_alloy");
        public static final TagKey<Item> STORAGE_BLOCKS_FIREITE = Items.createForgeTag("storage_blocks/fireite");
        public static final TagKey<Item> ORES_INERT_CRYSTAL = Items.createForgeTag("ores/inert_crystal");
        public static final TagKey<Item> CURIOS_ELEMENT_HOLDER = Items.createTag("curios", "element_holder");

        private Items() {
        }

        private static TagKey<Item> createTag(String name) {
            return Items.createTag("elementalcraft", name);
        }

        private static TagKey<Item> createTag(String namespace, String name) {
            return ItemTags.create((ResourceLocation)new ResourceLocation(namespace, name));
        }

        private static TagKey<Item> createForgeTag(String name) {
            return Items.createTag("forge", name);
        }

        public static HolderSet.Named<Item> getTag(ResourceLocation loc) {
            return Items.getTag((TagKey<Item> t) -> t.f_203868_().equals((Object)loc));
        }

        public static HolderSet.Named<Item> getTag(TagKey<Item> key) {
            return Items.getTag((TagKey<Item> t) -> t.equals((Object)key));
        }

        public static HolderSet.Named<Item> getTag(Predicate<TagKey<Item>> predicate) {
            return Registry.f_122827_.m_203612_().filter(p -> predicate.test((TagKey)p.getFirst())).map(Pair::getSecond).findFirst().orElse(null);
        }
    }
}

