/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.water;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import sirttas.elementalcraft.spell.Spell;

public class PurificationSpell
extends Spell {
    public static final String NAME = "purification";

    public PurificationSpell(ResourceKey<Spell> key) {
        super(key);
    }

    private InteractionResult cureEffects(Entity target) {
        if (target instanceof LivingEntity) {
            if (!target.m_183503_().f_46443_) {
                LivingEntity livingTarget = (LivingEntity)target;
                Iterator itr = livingTarget.m_21220_().iterator();
                while (itr.hasNext()) {
                    MobEffectInstance effect = (MobEffectInstance)itr.next();
                    if (effect.getCurativeItems().isEmpty() || effect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL || MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionRemoveEvent(livingTarget, effect))) continue;
                    livingTarget.m_7285_(effect);
                    itr.remove();
                    livingTarget.m_21210_();
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nonnull
    public InteractionResult castOnEntity(@Nonnull Entity caster, @Nonnull Entity target) {
        return this.cureEffects(target);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        return this.cureEffects(caster);
    }
}

