/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.properties;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.dpanvil.api.codec.Codecs;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.gui.ECColorHelper;
import sirttas.elementalcraft.spell.Spell;

public record SpellProperties(Spell.Type spellType, ElementType elementType, int weight, int useDuration, int consumeAmount, int cooldown, float range, int color, boolean hidden, Multimap<Attribute, AttributeModifier> attributes) implements IElementTypeProvider
{
    public static final String NAME = "spell_properties";
    public static final String FOLDER = "elementalcraft_spell_properties";
    public static final SpellProperties NONE = new SpellProperties();
    public static final Codec<SpellProperties> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Spell.Type.CODEC.fieldOf("spell_type").forGetter(SpellProperties::spellType), ElementType.forGetter(SpellProperties::elementType), (App)Codec.INT.optionalFieldOf("weight", (Object)0).forGetter(SpellProperties::weight), (App)Codec.INT.optionalFieldOf("use_duration", (Object)0).forGetter(SpellProperties::useDuration), (App)Codec.INT.optionalFieldOf("element_consumption", (Object)0).forGetter(SpellProperties::consumeAmount), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(SpellProperties::cooldown), (App)Codec.FLOAT.optionalFieldOf("range", (Object)Float.valueOf(0.0f)).forGetter(SpellProperties::range), (App)Codecs.COLOR.optionalFieldOf("color", (Object)-1).forGetter(SpellProperties::color), (App)Codec.BOOL.optionalFieldOf("hidden", (Object)false).forGetter(SpellProperties::hidden), (App)Codecs.ATTRIBUTE_MULTIMAP.optionalFieldOf("attributes", (Object)Multimaps.forMap(Collections.emptyMap())).forGetter(SpellProperties::getAttributes)).apply((Applicative)builder, SpellProperties::new));

    public SpellProperties() {
        this(Spell.Type.NONE, ElementType.NONE, 0, 0, 0, 0, 0.0f, -1, true, null);
    }

    public SpellProperties(Spell.Type spellType, ElementType elementType, int weight, int useDuration, int consumeAmount, int cooldown, float range, int color, boolean hidden, Multimap<Attribute, AttributeModifier> attributes) {
        this.spellType = spellType;
        this.elementType = elementType;
        this.weight = weight;
        this.useDuration = useDuration;
        this.consumeAmount = consumeAmount;
        this.cooldown = cooldown;
        this.range = range;
        this.color = color;
        this.hidden = hidden;
        this.attributes = attributes != null ? Multimaps.unmodifiableMultimap(attributes) : Multimaps.forMap(Collections.emptyMap());
    }

    public static ResourceKey<SpellProperties> getKey(ResourceKey<Spell> key) {
        return IDataManager.createKey(ElementalCraft.SPELL_PROPERTIES_MANAGER_KEY, (ResourceLocation)key.m_135782_());
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public Multimap<Attribute, AttributeModifier> getAttributes() {
        return this.attributes;
    }

    public static final class Builder {
        public static final Encoder<Builder> ENCODER = CodecHelper.remapField(CODEC, (MapEncoder)Codecs.HEX_COLOR.fieldOf("color"), p -> p.color).comap(builder -> new SpellProperties(builder.type, builder.elementType, builder.weight, builder.useDuration, builder.consumeAmount, builder.cooldown, (float)builder.range, builder.color, builder.hidden, builder.attributes));
        private int cooldown;
        private int consumeAmount;
        private int useDuration;
        private int weight;
        private int color;
        private double range;
        private boolean hidden;
        private ElementType elementType;
        private final Spell.Type type;
        private final Multimap<Attribute, AttributeModifier> attributes;

        private Builder(Spell.Type type) {
            this.type = type;
            this.elementType = ElementType.NONE;
            this.cooldown = 0;
            this.consumeAmount = 0;
            this.useDuration = 0;
            this.weight = 0;
            this.hidden = false;
            this.attributes = HashMultimap.create();
        }

        public static Builder create(Spell.Type type) {
            return new Builder(type);
        }

        public Builder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder consumeAmount(int consumeAmount) {
            this.consumeAmount = consumeAmount;
            return this;
        }

        public Builder useDuration(int useDuration) {
            this.useDuration = useDuration;
            return this;
        }

        public Builder elementType(ElementType elementType) {
            this.elementType = elementType;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder range(double range) {
            this.range = range;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder hidden() {
            this.hidden = true;
            return this;
        }

        public Builder addAttribute(Attribute attribute, AttributeModifier modifier) {
            this.attributes.put((Object)attribute, (Object)modifier);
            return this;
        }

        public Builder color(int r, int g, int b) {
            return this.color(ECColorHelper.packColor(r, g, b));
        }
    }
}

