/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.earth;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import sirttas.elementalcraft.spell.Spell;

public class StoneWallSpell
extends Spell {
    public static final String NAME = "stonewall";

    public StoneWallSpell(ResourceKey<Spell> key) {
        super(key);
    }

    private void spawn(Level world, BlockPos pos) {
        world.m_46597_(pos, Blocks.f_50069_.m_49966_());
    }

    private void checkAndSpawn(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_60767_().m_76336_()) {
            this.spawn(world, pos);
        }
    }

    public InteractionResult cast(Entity sender, BlockPos pos, Direction direction) {
        Level world = sender.m_183503_();
        this.checkAndSpawn(world, pos);
        this.checkAndSpawn(world, pos.m_142300_(direction.m_122427_()));
        this.checkAndSpawn(world, pos.m_142300_(direction.m_122428_()));
        this.checkAndSpawn(world, pos.m_6630_(1));
        this.checkAndSpawn(world, pos.m_6630_(2));
        this.checkAndSpawn(world, pos.m_142300_(direction.m_122427_()).m_6630_(1));
        this.checkAndSpawn(world, pos.m_142300_(direction.m_122427_()).m_6630_(2));
        this.checkAndSpawn(world, pos.m_142300_(direction.m_122428_()).m_6630_(1));
        this.checkAndSpawn(world, pos.m_142300_(direction.m_122428_()).m_6630_(2));
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        Optional<Direction> opt = Stream.of(Direction.m_122382_((Entity)caster)).filter(d -> d.m_122434_() != Direction.Axis.Y).findFirst();
        if (!opt.isPresent()) {
            return InteractionResult.PASS;
        }
        return this.cast(caster, new BlockPos(caster.m_20182_()).m_5484_(opt.get(), 3), opt.get());
    }

    @Override
    public boolean consume(Entity sender, boolean simulate) {
        boolean value = this.consume(sender, (ItemLike)Blocks.f_50069_, 9, simulate);
        return super.consume(sender, simulate) && value;
    }

    @Override
    public void addInformation(List<Component> tooltip) {
        tooltip.add((Component)new TranslatableComponent("tooltip.elementalcraft.consumes", new Object[]{new TranslatableComponent("tooltip.elementalcraft.count", new Object[]{9, Blocks.f_50069_.m_49954_()})}).m_130940_(ChatFormatting.YELLOW));
    }
}

