/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.earth;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.spell.Spell;

public class GavelFallSpell
extends Spell {
    public static final String NAME = "gravelfall";

    public GavelFallSpell(ResourceKey<Spell> key) {
        super(key);
    }

    private void spawn(Level world, BlockPos pos) {
        FallingBlockEntity entity = FallingBlockEntity.m_201971_((Level)world, (BlockPos)pos, (BlockState)Blocks.f_49994_.m_49966_());
        entity.f_31942_ = 1;
        entity.m_149656_(1.0f, 100);
        world.m_7967_((Entity)entity);
    }

    private void checkAndSpawn(Level world, BlockPos pos) {
        if (world.m_46859_(pos)) {
            this.spawn(world, pos);
        }
    }

    private InteractionResult spawnGravel(Entity sender, BlockPos pos) {
        Level world = sender.m_183503_();
        this.checkAndSpawn(world, pos.m_6630_(4));
        this.checkAndSpawn(world, pos.m_6630_(5));
        this.checkAndSpawn(world, pos.m_6630_(6));
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nonnull
    public InteractionResult castOnBlock(@Nonnull Entity sender, @Nonnull BlockPos target) {
        return this.spawnGravel(sender, target);
    }

    @Override
    @Nonnull
    public InteractionResult castOnEntity(@Nonnull Entity caster, @Nonnull Entity target) {
        return this.spawnGravel(caster, new BlockPos(target.m_20182_()));
    }

    @Override
    public boolean consume(Entity sender, boolean simulate) {
        boolean value = this.consume(sender, (ItemLike)Blocks.f_49994_, 3, simulate);
        return super.consume(sender, simulate) && value;
    }

    @Override
    public void addInformation(List<Component> tooltip) {
        tooltip.add((Component)new TranslatableComponent("tooltip.elementalcraft.consumes", new Object[]{new TranslatableComponent("tooltip.elementalcraft.count", new Object[]{3, Blocks.f_49994_.m_49954_()})}).m_130940_(ChatFormatting.YELLOW));
    }
}

