/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.air;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import sirttas.elementalcraft.spell.Spell;

public class TranslocationSpell
extends Spell {
    public static final String NAME = "translocation";

    public TranslocationSpell(ResourceKey<Spell> key) {
        super(key);
    }

    private void teleport(Entity sender, Vec3 newPos) {
        sender.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        Level world = caster.m_183503_();
        Vec3 look = caster.m_20154_();
        Vec3 tagetPos = caster.m_20182_().m_82549_(new Vec3(look.m_7096_(), 0.0, look.m_7094_()).m_82541_().m_82490_((double)this.getRange(caster)));
        Vec3 newPos = new Vec3(tagetPos.m_7096_(), this.getHeight(world, caster, tagetPos), tagetPos.m_7094_());
        if (world.m_6325_((int)Math.round(newPos.f_82479_) >> 4, (int)Math.round(newPos.f_82481_) >> 4) == null) {
            return InteractionResult.FAIL;
        }
        if (MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)new Event(caster, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_))) {
            return InteractionResult.SUCCESS;
        }
        if (caster instanceof LivingEntity) {
            LivingEntity livingSender = (LivingEntity)caster;
            this.teleport(caster, newPos);
            livingSender.m_183503_().m_6263_(null, livingSender.f_19854_, livingSender.f_19855_, livingSender.f_19856_, SoundEvents.f_11852_, livingSender.m_5720_(), 1.0f, 1.0f);
            livingSender.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        } else {
            this.teleport(caster, newPos);
        }
        return InteractionResult.SUCCESS;
    }

    private double getHeight(Level world, Entity sender, Vec3 tagetPos) {
        double height = (double)world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(tagetPos)).m_123342_() + 1.0;
        if (!sender.m_20096_()) {
            return Math.max(height, sender.m_20186_());
        }
        return height;
    }

    public static class Event
    extends EntityTeleportEvent {
        public Event(Entity entity, double targetX, double targetY, double targetZ) {
            super(entity, targetX, targetY, targetZ);
        }
    }
}

