/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sirttas.elementalcraft.network.message.MessageHelper;
import sirttas.elementalcraft.spell.AbstractSpellInstance;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellTickCooldownMessage;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class SpellTickManager {
    public static final SpellTickManager SERVER_INSTANCE = new SpellTickManager();
    public static final SpellTickManager CLIENT_INSTANCE = new SpellTickManager();
    private int tick = 0;
    private final Map<Entity, Map<Spell, Cooldown>> cooldowns = new HashMap<Entity, Map<Spell, Cooldown>>();
    private final List<AbstractSpellInstance> spellInstances = Lists.newArrayList();

    private SpellTickManager() {
    }

    public static SpellTickManager getInstance(Level world) {
        return world.f_46443_ ? CLIENT_INSTANCE : SERVER_INSTANCE;
    }

    @Nullable
    public static AbstractSpellInstance getSpellInstance(Entity caster, Spell spell) {
        if (caster == null || caster.m_146910_()) {
            return null;
        }
        return SpellTickManager.getInstance((Level)caster.f_19853_).spellInstances.stream().filter(spellInstance -> spellInstance.getCaster().equals((Object)caster) && spellInstance.getSpell().equals(spell)).findFirst().orElse(null);
    }

    @Nonnull
    public static List<AbstractSpellInstance> getSpellInstances(Entity caster) {
        if (caster == null || caster.m_146910_()) {
            return Collections.emptyList();
        }
        return SpellTickManager.getInstance((Level)caster.f_19853_).spellInstances.stream().filter(spellInstance -> spellInstance.getCaster().equals((Object)caster)).toList();
    }

    private void tick() {
        ++this.tick;
        this.cooldowns.keySet().removeIf(e -> !e.m_6084_());
        this.cooldowns.forEach((k, v) -> v.values().removeIf(c -> c.expireTicks <= this.tick));
        if (this.cooldowns.isEmpty()) {
            this.tick = 0;
        }
        this.spellInstances.removeIf(AbstractSpellInstance::isFinished);
        this.spellInstances.forEach(i -> {
            i.tick();
            i.decTick();
        });
        this.spellInstances.removeIf(AbstractSpellInstance::isFinished);
    }

    public void addSpellInstance(AbstractSpellInstance instance) {
        this.spellInstances.add(instance);
    }

    public void setCooldown(Entity target, Spell spell) {
        Map<Object, Object> entityCooldowns;
        Cooldown cooldown = new Cooldown(this.tick, this.tick + spell.getCooldown());
        if (!this.cooldowns.containsKey(target)) {
            entityCooldowns = new HashMap();
            this.cooldowns.put(target, entityCooldowns);
        } else {
            entityCooldowns = this.cooldowns.get(target);
        }
        entityCooldowns.put(spell, cooldown);
        if (!target.f_19853_.f_46443_ && target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            MessageHelper.sendToPlayer(player, new SpellTickCooldownMessage(spell));
        }
    }

    public boolean hasCooldown(Entity target, Spell spell) {
        return this.getCooldown(target, spell) > 0.0f;
    }

    public float getCooldown(Entity target, Spell spell) {
        return this.getCooldown(target, spell, 0.0f);
    }

    public float getCooldown(Entity target, Spell spell, float partialTick) {
        Map<Spell, Cooldown> entityCooldowns = this.cooldowns.get(target);
        if (spell.isValid() && entityCooldowns != null && entityCooldowns.containsKey(spell)) {
            Cooldown cooldown = entityCooldowns.get(spell);
            float current = (float)cooldown.expireTicks - ((float)this.tick + partialTick);
            float total = (float)cooldown.expireTicks - (float)cooldown.createTicks;
            return current / total;
        }
        return 0.0f;
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            SERVER_INSTANCE.tick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CLIENT_INSTANCE.tick();
        }
    }

    private static class Cooldown {
        private final int createTicks;
        private final int expireTicks;

        private Cooldown(int createTicksIn, int expireTicksIn) {
            this.createTicks = createTicksIn;
            this.expireTicks = expireTicksIn;
        }
    }
}

