/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellTickManager;
import sirttas.elementalcraft.spell.Spells;

public class SpellTickCooldownMessage {
    private final Spell spell;

    public SpellTickCooldownMessage(Spell spell) {
        this.spell = spell;
    }

    public static SpellTickCooldownMessage decode(FriendlyByteBuf buf) {
        return new SpellTickCooldownMessage((Spell)Spells.REGISTRY.get().getValue(buf.m_130281_()));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.spell.getRegistryName());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                this.setCooldown();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setCooldown() {
        SpellTickManager.CLIENT_INSTANCE.setCooldown((Entity)Minecraft.m_91087_().f_91074_, this.spell);
    }
}

