/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.event.TickHandler;

public interface IECGenericRenderer {
    default public Quaternion getRotation(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> Vector3f.f_122225_.m_122240_(180.0f);
            case Direction.WEST -> Vector3f.f_122225_.m_122240_(90.0f);
            case Direction.EAST -> Vector3f.f_122225_.m_122240_(-90.0f);
            default -> Quaternion.f_80118_.m_80161_();
        };
    }

    default public void renderItem(ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, light, overlay, matrixStack, buffer, 0);
    }

    default public void renderBlock(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay, IModelData data) {
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStack, buffer, light, overlay, data);
    }

    default public void renderBlock(BlockState state, PoseStack matrixStack, VertexConsumer builder, Level world, BlockPos pos) {
        matrixStack.m_85836_();
        Minecraft.m_91087_().m_91289_().renderBatched(state, pos, (BlockAndTintGetter)world, matrixStack, builder, false, world.f_46441_, this.getModelData(world, pos));
        matrixStack.m_85849_();
    }

    default public void renderRunes(PoseStack matrixStack, MultiBufferSource buffer, IRuneHandler handler, float tick, int light, int overlay) {
        int runeCount = handler.getRuneCount();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.75, 0.5);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(tick / 2.0f));
        handler.getRunes().forEach(rune -> {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f / (float)runeCount));
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.75, 0.0, 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            matrixStack.m_85841_(0.015625f, 0.015625f, 0.015625f);
            this.renderIcon(matrixStack, buffer, rune.getSprite(), 16, -16, light, overlay);
            matrixStack.m_85849_();
        });
        matrixStack.m_85849_();
    }

    default public void renderIcon(PoseStack poseStack, MultiBufferSource buffer, Material renderMaterial, int width, int height, int light, int overlay) {
        this.renderIcon(poseStack, renderMaterial.m_119194_(buffer, RenderType::m_110473_), 0.0f, 0.0f, renderMaterial, width, height, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    default public void renderIcon(PoseStack poseStack, VertexConsumer builder, Material renderMaterial, int width, int height, int light, int overlay) {
        this.renderIcon(poseStack, builder, 0.0f, 0.0f, renderMaterial, width, height, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    default public void renderIcon(PoseStack poseStack, MultiBufferSource buffer, float x, float y, Material renderMaterial, int width, int height, float r, float g, float b, int light, int overlay) {
        this.renderIcon(poseStack, renderMaterial.m_119194_(buffer, RenderType::m_110473_), x, y, renderMaterial, width, height, r, g, b, light, overlay);
    }

    default public void renderIcon(PoseStack poseStack, VertexConsumer builder, float x, float y, Material renderMaterial, int width, int height, float r, float g, float b, int light, int overlay) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Matrix3f normal = poseStack.m_85850_().m_85864_();
        TextureAtlasSprite sprite = renderMaterial.m_119204_();
        builder.m_85982_(matrix, x, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, x + (float)width, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, x + (float)width, y + (float)height, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, x, y + (float)height, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    @Deprecated
    default public void renderModel(BakedModel model, PoseStack matrixStack, MultiBufferSource buffer, BlockState state, int light, int overlay) {
        this.renderModel(model, matrixStack, buffer, state, light, overlay, (IModelData)EmptyModelData.INSTANCE);
    }

    default public void renderModel(BakedModel model, PoseStack matrixStack, MultiBufferSource buffer, BlockState state, int light, int overlay, IModelData data) {
        Minecraft.m_91087_().m_91289_().m_110937_().renderModel(matrixStack.m_85850_(), buffer.m_6299_(state != null ? ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false) : Sheets.m_110790_()), state, model, 1.0f, 1.0f, 1.0f, light, overlay, data);
    }

    default public float getAngle(float partialTicks) {
        return (float)TickHandler.getTicksInGame() + partialTicks % 360.0f;
    }

    default public IModelData getModelData(Level level, BlockPos pos) {
        IModelData data = ModelDataManager.getModelData((Level)level, (BlockPos)pos);
        if (data == null) {
            return EmptyModelData.INSTANCE;
        }
        return data;
    }
}

