/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.registry;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.ElementalCraft;

public class RegistryHelper {
    private RegistryHelper() {
    }

    public static <V extends IForgeRegistryEntry<V>> void register(IForgeRegistry<V> reg, IForgeRegistryEntry<V> thing, ResourceLocation name) {
        reg.register((IForgeRegistryEntry)thing.setRegistryName(name));
    }

    public static <V extends IForgeRegistryEntry<V>> void register(IForgeRegistry<V> reg, IForgeRegistryEntry<V> thing, String name) {
        RegistryHelper.register(reg, thing, ElementalCraft.createRL(name));
    }

    public static <V extends IForgeRegistryEntry<V>> void register(IForgeRegistry<V> reg, IForgeRegistryEntry<V> thing, RegistryObject<?> object) {
        RegistryHelper.register(reg, thing, object.getId());
    }

    public static <T extends IForgeRegistryEntry<T>, U extends T> RegistryObject<U> object(String name, IForgeRegistry<T> registry) {
        return RegistryObject.create((ResourceLocation)ElementalCraft.createRL(name), registry);
    }

    public static <T extends IForgeRegistryEntry<T>> Supplier<IForgeRegistry<T>> makeRegistry(DeferredRegister<T> deferredRegister, Class<T> clazz) {
        return RegistryHelper.makeRegistry(deferredRegister, clazz, UnaryOperator.identity());
    }

    public static <T extends IForgeRegistryEntry<T>> Supplier<IForgeRegistry<T>> makeRegistry(DeferredRegister<T> deferredRegister, Class<T> clazz, UnaryOperator<RegistryBuilder<T>> mapper) {
        return deferredRegister.makeRegistry(clazz, () -> (RegistryBuilder)mapper.apply(new RegistryBuilder()));
    }
}

