/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.registry;

import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.ElementalCraftApi;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class MissingMappingsHandler {
    private static final Map<String, String> NAME_REMAP = Map.of("tank", "container", "tank_small", "small_container", "tank_creative", "creative_container", "inertcrystal", "inert_crystal", "crystalore", "inert_crystal_ore", "containedcrystal", "contained_crystal");

    private MissingMappingsHandler() {
    }

    @SubscribeEvent
    public static void remapMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        MissingMappingsHandler.remapMissingMappings(event, ForgeRegistries.BLOCKS);
    }

    @SubscribeEvent
    public static void remapMissingBlockEntityTypeMappings(RegistryEvent.MissingMappings<BlockEntityType<?>> event) {
        MissingMappingsHandler.remapMissingMappings(event, ForgeRegistries.BLOCK_ENTITIES);
    }

    @SubscribeEvent
    public static void remapMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        MissingMappingsHandler.remapMissingMappings(event, ForgeRegistries.ITEMS);
    }

    private static <T extends IForgeRegistryEntry<T>> void remapMissingMappings(RegistryEvent.MissingMappings<T> event, IForgeRegistry<T> registry) {
        IForgeRegistryEntry defaultValue = registry.getDefaultKey() != null ? registry.getValue(registry.getDefaultKey()) : null;
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("elementalcraft")) {
            IForgeRegistryEntry entity;
            ResourceLocation oldId = mapping.key;
            String oldName = oldId.m_135815_();
            String newName = NAME_REMAP.get(oldName);
            if (newName == null || (entity = registry.getValue(ElementalCraft.createRL(newName))) == null || entity == defaultValue) continue;
            mapping.remap(entity);
            ElementalCraftApi.LOGGER.info(ForgeRegistry.REGISTRIES, "Re-mapped {} \"{}\" to \"{}\"", (Object)registry.getRegistryName(), (Object)oldName, (Object)newName);
        }
    }
}

