/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.io.grinding;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.instrument.io.mill.AirMillBlockEntity;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.io.grinding.IGrindingRecipe;

public record AirMillGrindingRecipe(ResourceLocation id, Ingredient ingredient, ItemStack output, int elementAmount, int luckRation) implements IGrindingRecipe
{
    @ObjectHolder(value="elementalcraft:grinding")
    public static final RecipeSerializer<AirMillGrindingRecipe> SERIALIZER = null;

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.ingredient.test(stack) && IGrindingRecipe.super.matches(stack);
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.ingredient});
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.output;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public int getLuck(AirMillBlockEntity instrument) {
        return Math.round(instrument.getRuneHandler().getBonus(Rune.BonusType.LUCK) * (float)this.luckRation);
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<AirMillGrindingRecipe> {
        @Nonnull
        public AirMillGrindingRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            int elementAmount = GsonHelper.m_13927_((JsonObject)json, (String)"element_amount");
            Ingredient ingredient = RecipeHelper.deserializeIngredient(json, "input");
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            int luckRation = GsonHelper.m_13927_((JsonObject)json, (String)"luck_ration");
            if (!output.m_41619_()) {
                return new AirMillGrindingRecipe(recipeId, ingredient, output, elementAmount, luckRation);
            }
            throw new IllegalStateException("Binding recipe output is empty!");
        }

        public AirMillGrindingRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int elementAmount = buffer.readInt();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            int luckRation = buffer.readInt();
            return new AirMillGrindingRecipe(recipeId, ingredient, output, elementAmount, luckRation);
        }

        public void toNetwork(FriendlyByteBuf buffer, AirMillGrindingRecipe recipe) {
            buffer.writeInt(recipe.getElementAmount());
            ((Ingredient)recipe.m_7527_().get(0)).m_43923_(buffer);
            buffer.m_130055_(recipe.m_8043_());
            buffer.writeInt(recipe.luckRation());
        }
    }
}

