/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.infusion;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.data.IDataWrapper;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.infusion.tool.ToolInfusion;
import sirttas.elementalcraft.block.instrument.infuser.IInfuser;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;

public class ToolInfusionRecipe
implements IInfusionRecipe {
    public static final String NAME = "tool_infusion";
    @ObjectHolder(value="elementalcraft:tool_infusion")
    public static final RecipeSerializer<ToolInfusionRecipe> SERIALIZER = null;
    private final Ingredient input;
    private final int elementAmount;
    private final IDataWrapper<ToolInfusion> toolInfusion;
    protected final ResourceLocation id;

    public ToolInfusionRecipe(ResourceLocation id, ResourceLocation toolInfusion, Ingredient input, int elementAmount) {
        this.id = id;
        this.toolInfusion = ElementalCraftApi.TOOL_INFUSION_MANAGER.getWrapper(toolInfusion);
        this.input = input;
        this.elementAmount = elementAmount;
    }

    @Override
    public boolean matches(IInfuser instrument) {
        return IInfusionRecipe.super.matches(instrument) && !this.getToolInfusion().equals(ToolInfusionHelper.getInfusion(instrument.getItem()));
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public ItemStack assemble(IInfuser instrument) {
        ItemStack stack = instrument.getItem().m_41777_();
        ToolInfusionHelper.setInfusion(stack, this.getToolInfusion());
        return stack;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_5598_() {
        return true;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public ElementType getElementType() {
        return this.getToolInfusion().getElementType();
    }

    public ToolInfusion getToolInfusion() {
        return (ToolInfusion)this.toolInfusion.get();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ToolInfusionRecipe> {
        @Nonnull
        public ToolInfusionRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            int elementAmount = GsonHelper.m_13927_((JsonObject)json, (String)"element_amount");
            Ingredient input = RecipeHelper.deserializeIngredient(json, "input");
            ResourceLocation toolInfusion = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)ToolInfusionRecipe.NAME));
            return new ToolInfusionRecipe(recipeId, toolInfusion, input, elementAmount);
        }

        public ToolInfusionRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int elementAmount = buffer.readInt();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ResourceLocation toolInfusion = buffer.m_130281_();
            return new ToolInfusionRecipe(recipeId, toolInfusion, input, elementAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, ToolInfusionRecipe recipe) {
            buffer.writeInt(recipe.getElementAmount());
            recipe.getInput().m_43923_(buffer);
            buffer.m_130085_(recipe.getToolInfusion().getId());
        }
    }
}

