/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.IECRecipe;
import sirttas.elementalcraft.recipe.RecipeHelper;

public class SpellCraftRecipe
implements IECRecipe<Container> {
    public static final String NAME = "spell_craft";
    public static final RecipeType<SpellCraftRecipe> TYPE = (RecipeType)Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)ElementalCraft.createRL("spell_craft"), (Object)new RecipeType<SpellCraftRecipe>(){

        public String toString() {
            return SpellCraftRecipe.NAME;
        }
    });
    @ObjectHolder(value="elementalcraft:spell_craft")
    public static final RecipeSerializer<SpellCraftRecipe> SERIALIZER = null;
    private static final Ingredient SCROLL_PAPER = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ECItems.SCROLL_PAPER});
    private final Ingredient gem;
    private final Ingredient crystal;
    private final ItemStack output;
    private final ResourceLocation id;

    public SpellCraftRecipe(ResourceLocation id, ItemStack output, Ingredient gem, Ingredient crystal) {
        this.id = id;
        this.output = output;
        this.gem = gem;
        this.crystal = crystal;
    }

    public boolean m_5818_(Container inv, @Nonnull Level worldIn) {
        return SCROLL_PAPER.test(inv.m_8020_(0)) && this.gem.test(inv.m_8020_(1)) && this.crystal.test(inv.m_8020_(2));
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.output;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{SCROLL_PAPER, this.gem, this.crystal});
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<SpellCraftRecipe> m_7707_() {
        return SERIALIZER;
    }

    @Nonnull
    public RecipeType<SpellCraftRecipe> m_6671_() {
        return TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SpellCraftRecipe> {
        @Nonnull
        public SpellCraftRecipe fromJson(@Nonnull ResourceLocation recipeId, JsonObject json) {
            Ingredient gem = Ingredient.m_43917_((JsonElement)json.get("gem"));
            Ingredient crystal = Ingredient.m_43917_((JsonElement)json.get("crystal"));
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            return new SpellCraftRecipe(recipeId, output, gem, crystal);
        }

        public SpellCraftRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            Ingredient gem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient crystal = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            return new SpellCraftRecipe(recipeId, output, gem, crystal);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, SpellCraftRecipe recipe) {
            recipe.gem.m_43923_(buffer);
            recipe.crystal.m_43923_(buffer);
            buffer.m_130055_(recipe.m_8043_());
        }
    }
}

