/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import sirttas.elementalcraft.container.ECContainerHelper;

public class RecipeHelper {
    private RecipeHelper() {
    }

    public static Ingredient deserializeIngredient(JsonObject json, String key) {
        if (GsonHelper.m_13885_((JsonObject)json, (String)key)) {
            return Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)key));
        }
        return Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)key));
    }

    public static ItemStack readRecipeOutput(JsonObject json, String key) {
        if (json.has(key)) {
            JsonElement element = json.get(key);
            if (element.isJsonPrimitive()) {
                return RecipeHelper.readRecipeOutput(element.getAsString());
            }
            return ShapedRecipe.m_151274_((JsonObject)element.getAsJsonObject());
        }
        throw new JsonSyntaxException("Missing " + key + ", expected to find a string");
    }

    private static ItemStack readRecipeOutput(String output) {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(output)));
    }

    public static NonNullList<Ingredient> readIngredients(JsonArray json) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < json.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get(i));
            if (ingredient.m_43947_()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public static boolean matchesUnordered(Container inv, List<Ingredient> ingredients) {
        HashSet usedIndex = Sets.newHashSet();
        int count = ECContainerHelper.getItemCount(inv);
        return ingredients.stream().allMatch(ingredient -> {
            for (int i = 0; i < count; ++i) {
                if (!ingredient.test(inv.m_8020_(i)) || usedIndex.contains(i)) continue;
                usedIndex.add(i);
                return true;
            }
            return false;
        }) && usedIndex.size() == count;
    }
}

