/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore.injector;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.pureore.PureOreException;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.interaction.ECinteractions;
import sirttas.elementalcraft.interaction.mekanism.MekanismInteraction;
import sirttas.elementalcraft.pureore.injector.PureOreCookingRecipeInjector;
import sirttas.elementalcraft.pureore.injector.PureOreGrindingRecipeInjector;
import sirttas.elementalcraft.registry.RegistryHelper;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PureOreRecipeInjectors {
    private PureOreRecipeInjectors() {
    }

    @SubscribeEvent
    public static void registerPureOreRecipeInjectors(RegistryEvent.Register<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> event) {
        IForgeRegistry registry = event.getRegistry();
        if (Boolean.TRUE.equals(ECConfig.COMMON.pureOreSmeltingRecipe.get())) {
            PureOreRecipeInjectors.register(registry, new PureOreCookingRecipeInjector<SmeltingRecipe>(RecipeType.f_44108_, SmeltingRecipe::new));
        }
        if (Boolean.TRUE.equals(ECConfig.COMMON.pureOreBlastingRecipe.get())) {
            PureOreRecipeInjectors.register(registry, new PureOreCookingRecipeInjector<BlastingRecipe>(RecipeType.f_44109_, BlastingRecipe::new));
        }
        if (Boolean.TRUE.equals(ECConfig.COMMON.pureOreCampFireRecipe.get())) {
            PureOreRecipeInjectors.register(registry, new PureOreCookingRecipeInjector<CampfireCookingRecipe>(RecipeType.f_44111_, CampfireCookingRecipe::new));
        }
        PureOreRecipeInjectors.register(registry, new PureOreGrindingRecipeInjector());
        if (ECinteractions.isMekanismActive()) {
            MekanismInteraction.registerPureOreRecipeInjectors(registry);
        }
    }

    public static <C extends Container, T extends Recipe<C>> void register(IForgeRegistry<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> registry, AbstractPureOreRecipeInjector<C, T> injector) {
        ResourceLocation id = injector.getRecipeTypeRegistryName();
        if (id == null) {
            throw new PureOreException("Cannot register injector as its RecipeType is absent in registry.");
        }
        RegistryHelper.register(registry, injector, ElementalCraft.createRL(id.m_135827_() + "_" + id.m_135815_()));
    }
}

