/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore;

import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.NBTIngredient;
import org.apache.logging.log4j.util.Supplier;
import sirttas.dpanvil.api.event.DataPackReloadCompleteEvent;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.nbt.NBTHelper;
import sirttas.elementalcraft.pureore.PureOre;
import sirttas.elementalcraft.pureore.PureOreLoader;
import sirttas.elementalcraft.recipe.instrument.io.IPurifierRecipe;
import sirttas.elementalcraft.tag.ECTags;

public class PureOreManager {
    private static final PureOreLoader ORE_LOADER = PureOreLoader.create(ECTags.Items.PURE_ORES_ORE_SOURCE).pattern("_?ore$").tagFolder("ores").inputSize((Integer)ECConfig.COMMON.pureOreOresInput.get()).outputSize((Integer)ECConfig.COMMON.pureOreOresOutput.get()).luckRatio((Double)ECConfig.COMMON.pureOreOresLuckRatio.get());
    private static final PureOreLoader RAW_MATERIALS_LOADER = PureOreLoader.create(ECTags.Items.PURE_ORES_RAW_METAL_SOURCE).pattern("^raw_?").tagFolder("raw_materials").inputSize((Integer)ECConfig.COMMON.pureOreRawMaterialsInput.get()).outputSize((Integer)ECConfig.COMMON.pureOreRawMaterialsOutput.get()).luckRatio((Double)ECConfig.COMMON.pureOreRawMaterialsLuckRatio.get());
    private final Map<ResourceLocation, Entry> pureOres = new HashMap<ResourceLocation, Entry>();

    public boolean isValidOre(ItemStack ore) {
        return this.pureOres.values().stream().anyMatch(e -> e.test(ore));
    }

    private ResourceLocation getPureOreId(ItemStack stack) {
        CompoundTag nbt = NBTHelper.getECTag(stack);
        if (nbt != null) {
            return new ResourceLocation(nbt.m_128461_("ore"));
        }
        return null;
    }

    public IPurifierRecipe getRecipes(ItemStack ore) {
        return this.pureOres.values().stream().filter(e -> e.test(ore)).mapMulti((e, downstream) -> e.getRecipes().forEach(downstream)).filter(r -> r.matches(ore)).findAny().orElse(null);
    }

    public static Collection<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> getInjectors() {
        return AbstractPureOreRecipeInjector.REGISTRY.getValues();
    }

    public Component getPureOreName(ItemStack stack) {
        Entry entry = this.pureOres.get(this.getPureOreId(stack));
        return entry != null ? entry.getDescription() : null;
    }

    public ItemStack createPureOre(ResourceLocation id) {
        if (this.pureOres.containsKey(id)) {
            ItemStack stack = new ItemStack((ItemLike)ECItems.PURE_ORE);
            NBTHelper.getOrCreateECTag(stack).m_128359_("ore", id.toString());
            return stack;
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColor(ItemStack stack) {
        Entry entry = this.pureOres.get(this.getPureOreId(stack));
        return entry != null ? entry.getColor() : -1;
    }

    public List<ResourceLocation> getOres() {
        return new ArrayList<ResourceLocation>(this.pureOres.keySet());
    }

    public List<IPurifierRecipe> getRecipes() {
        return this.pureOres.values().stream().mapMulti((e, downstream) -> e.getRecipes().forEach(downstream)).toList();
    }

    public void reload(DataPackReloadCompleteEvent event) {
        Instant start = Instant.now();
        RecipeManager recipeManager = event.getRecipeManager();
        Collection<AbstractPureOreRecipeInjector<?, Recipe<?>>> injectors = PureOreManager.getInjectors();
        ElementalCraftApi.LOGGER.info("Pure ore generation started.\n\r\tRecipe Types: {}", new Supplier[]{() -> injectors.stream().map(AbstractPureOreRecipeInjector::toString).collect(Collectors.joining(", "))});
        injectors.forEach(injector -> injector.init(recipeManager));
        this.pureOres.clear();
        ORE_LOADER.generate(injectors).forEach(e -> {
            this.pureOres.computeIfAbsent((ResourceLocation)e.getId(), (Function<ResourceLocation, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$reload$7(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lsirttas/elementalcraft/pureore/PureOreManager$Entry;)()).ore = e;
        });
        RAW_MATERIALS_LOADER.generate(injectors).forEach(e -> {
            this.pureOres.computeIfAbsent((ResourceLocation)e.getId(), (Function<ResourceLocation, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$reload$9(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lsirttas/elementalcraft/pureore/PureOreManager$Entry;)()).rawMaterial = e;
        });
        if (Boolean.TRUE.equals(ECConfig.COMMON.pureOreRecipeInjection.get())) {
            ElementalCraftApi.LOGGER.info("Pure ore recipe injection.");
            this.pureOres.values().removeIf(o -> !o.isProcessable());
            List<Entry> entries = this.pureOres.values().stream().distinct().toList();
            List recipes = recipeManager.m_44051_().stream().filter(r -> !this.isPureOreRecipe((Recipe<?>)r)).collect(Collectors.toList());
            int size = recipes.size();
            injectors.forEach(injector -> this.inject((AbstractPureOreRecipeInjector)((Object)injector), recipes, entries));
            recipeManager.m_44024_(recipes);
            ElementalCraftApi.LOGGER.info("Pure ore recipe injection finished. {} recipes added.", new Supplier[]{() -> recipeManager.m_44051_().size() - size});
        }
        ElementalCraftApi.LOGGER.info("Pure ore generation ended\r\n\tOres: {} in {}.", new Supplier[]{() -> this.pureOres.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")), () -> Duration.between(start, Instant.now())});
    }

    private boolean isPureOreRecipe(Recipe<?> recipe) {
        ResourceLocation id = recipe.m_6423_();
        return id.m_135827_().equals("elementalcraft") && id.m_135815_().startsWith("pure_ore/");
    }

    private <C extends Container, T extends Recipe<C>> void inject(AbstractPureOreRecipeInjector<C, T> injector, Collection<Recipe<?>> recipes, List<Entry> entries) {
        entries.stream().distinct().mapMulti((entry, downstream) -> {
            if (entry.ore != null) {
                downstream.accept(this.injectEntry(injector, entry.ore));
            }
            if (entry.rawMaterial != null) {
                downstream.accept(this.injectEntry(injector, entry.rawMaterial));
            }
        }).filter(Objects::nonNull).filter(ElementalCraftUtils.distinctBy(Recipe::m_6423_)).forEach(recipes::add);
    }

    private <C extends Container, T extends Recipe<C>> T injectEntry(AbstractPureOreRecipeInjector<C, T> injector, PureOre entry) {
        RecipeType<T> recipeType = injector.getRecipeType();
        try {
            T recipe = entry.getRecipe(recipeType);
            return recipe != null ? (T)injector.build(recipe, (Ingredient)NBTIngredient.of((ItemStack)this.createPureOre(entry.getId()))) : null;
        }
        catch (Exception e) {
            ElementalCraftApi.LOGGER.error("Error in pure ore recipe injection", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ Entry lambda$reload$9(ResourceLocation i) {
        return new Entry();
    }

    private static /* synthetic */ Entry lambda$reload$7(ResourceLocation i) {
        return new Entry();
    }

    private static class Entry {
        private int color = -1;
        private PureOre ore;
        private PureOre rawMaterial;

        private Entry() {
        }

        public Component getDescription() {
            if (this.ore != null) {
                return this.ore.getDescription();
            }
            if (this.rawMaterial != null) {
                return this.rawMaterial.getDescription();
            }
            return null;
        }

        public boolean test(ItemStack ore) {
            return this.ore != null && this.ore.getIngredient().test(ore) || this.rawMaterial != null && this.rawMaterial.getIngredient().test(ore);
        }

        public boolean isProcessable() {
            return this.ore != null && this.ore.isProcessable() || this.rawMaterial != null && this.rawMaterial.isProcessable();
        }

        public List<IPurifierRecipe> getRecipes() {
            IPurifierRecipe recipe;
            ArrayList<IPurifierRecipe> list = new ArrayList<IPurifierRecipe>();
            if (this.ore != null && (recipe = this.ore.getRecipe()) != null) {
                list.add(recipe);
            }
            if (this.rawMaterial != null && (recipe = this.rawMaterial.getRecipe()) != null) {
                list.add(recipe);
            }
            return list;
        }

        @OnlyIn(value=Dist.CLIENT)
        private int getColor() {
            if (this.color == -1) {
                if (this.ore != null) {
                    this.color = ECItem.lookupColor(this.ore.getResultForColor());
                } else if (this.rawMaterial != null) {
                    this.color = ECItem.lookupColor(this.rawMaterial.getResultForColor());
                }
            }
            return this.color;
        }
    }
}

