/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.common.util.Lazy;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Supplier;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.pureore.PureOre;
import sirttas.elementalcraft.tag.ECTags;

public class PureOreLoader {
    private static final Pattern DEEPSLATE_PATTERN = Pattern.compile("^deepslate_");
    private final TagKey<Item> sourceTag;
    private final Lazy<HolderSet.Named<Item>> source;
    private Pattern pattern;
    private String tagFolder;
    private int inputSize;
    private int outputSize;
    private double luckRatio;

    private PureOreLoader(TagKey<Item> sourceTag) {
        this.sourceTag = sourceTag;
        this.source = Lazy.of(() -> ECTags.Items.getTag(sourceTag));
        this.inputSize = 1;
        this.outputSize = 2;
        this.luckRatio = 0.0;
    }

    public static PureOreLoader create(TagKey<Item> sourceTag) {
        return new PureOreLoader(sourceTag);
    }

    public PureOreLoader pattern(String pattern) {
        this.pattern = StringUtils.isNotBlank((CharSequence)pattern) ? Pattern.compile(pattern) : null;
        return this;
    }

    public PureOreLoader tagFolder(String tagFolder) {
        this.tagFolder = tagFolder;
        return this;
    }

    public PureOreLoader inputSize(int inputSize) {
        this.inputSize = inputSize;
        return this;
    }

    public PureOreLoader outputSize(int outputSize) {
        this.outputSize = outputSize;
        return this;
    }

    public PureOreLoader luckRatio(double luckRatio) {
        this.luckRatio = luckRatio;
        return this;
    }

    public List<PureOre> generate(Collection<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> injectors) {
        return List.copyOf(this.generatePureOres(injectors).values());
    }

    private Map<ResourceLocation, PureOre> generatePureOres(Collection<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> injectors) {
        HashMap<ResourceLocation, PureOre> pureOres = new HashMap<ResourceLocation, PureOre>();
        ElementalCraftApi.LOGGER.info("Loading pure ores.\r\n\tSource ores: {}", new Supplier[]{() -> this.streamSourceTag().mapMulti(ElementalCraftUtils.cast(Holder.Reference.class)).map(r -> r.m_205785_().m_135782_().toString()).collect(Collectors.joining(", "))});
        this.streamSourceTag().forEach(holder -> {
            Item ore = (Item)holder.m_203334_();
            PureOre entry = this.findOrCreateEntry(pureOres, ore);
            boolean isInBlacklist = holder.m_203656_(ECTags.Items.PURE_ORES_MOD_PROCESSING_BLACKLIST);
            injectors.forEach(injector -> {
                block3: {
                    block2: {
                        if (!injector.isModProcessing()) break block2;
                        if (isInBlacklist) break block3;
                    }
                    injector.getRecipe(ore).ifPresent(entry::addRecipe);
                }
            });
        });
        return pureOres;
    }

    @Nonnull
    private Stream<Holder<Item>> streamSourceTag() {
        HolderSet.Named value = (HolderSet.Named)this.source.get();
        if (value == null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> this.sourceTag.f_203868_();
            ElementalCraftApi.LOGGER.error("Source tag: {} is null!", supplierArray);
            return Stream.empty();
        }
        return value.m_203614_();
    }

    private PureOre findOrCreateEntry(Map<ResourceLocation, PureOre> pureOres, Item ore) {
        for (PureOre pureOre : pureOres.values()) {
            if (!pureOre.contains(ore)) continue;
            return pureOre;
        }
        ResourceLocation id = ore.getRegistryName();
        String path = DEEPSLATE_PATTERN.matcher(id.m_135815_()).replaceAll("");
        Matcher matcher = this.pattern != null ? this.pattern.matcher(path) : null;
        HolderSet.Named<Item> tag = null;
        if (this.tagFolder != null && matcher != null && matcher.find()) {
            path = matcher.replaceAll("");
            String namespace = id.m_135827_();
            String folderPath = this.tagFolder + "/";
            try {
                tag = ECTags.Items.getTag(k -> k.f_203868_().m_135827_().equals("forge") && StringUtils.startsWith((CharSequence)k.f_203868_().m_135815_(), (CharSequence)folderPath) && ore.m_204114_().m_203656_(k));
                if (tag != null) {
                    namespace = "forge";
                    path = StringUtils.removeStart((String)tag.m_205839_().f_203868_().m_135815_(), (String)folderPath);
                }
            }
            catch (Exception e) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> ((Item)ore).getRegistryName();
                supplierArray[1] = e::getMessage;
                ElementalCraftApi.LOGGER.trace("Tag Not found with {}: {}", supplierArray);
            }
            id = new ResourceLocation(namespace, path);
        }
        PureOre entry = pureOres.computeIfAbsent(id, i -> new PureOre((ResourceLocation)i, this.inputSize, this.outputSize, this.luckRatio));
        entry.getOres().add(ore);
        if (tag != null) {
            entry.addTag(tag);
        }
        return entry;
    }
}

