/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.particle;

import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.particle.ECParticles;
import sirttas.elementalcraft.particle.element.ElementTypeParticleData;

public class ParticleHelper {
    private ParticleHelper() {
    }

    public static void createSourceParticle(ElementType type, Level world, Vec3 pos, Random rand) {
        double x = pos.m_7096_() + (rand.nextDouble() * 2.0 - 1.0) / 16.0;
        double y = pos.m_7098_() - 0.1875;
        double z = pos.m_7094_() + (rand.nextDouble() * 2.0 - 1.0) / 16.0;
        world.m_7106_((ParticleOptions)new ElementTypeParticleData(ECParticles.SOURCE, type), x, y, z, 0.0, 0.0, 0.0);
    }

    public static void createExhaustedSourceParticle(ElementType type, Level world, Vec3 pos, Random rand) {
        double x = pos.m_7096_() + (rand.nextDouble() * 6.0 - 3.0) / 16.0;
        double y = pos.m_7098_() - 0.1875;
        double z = pos.m_7094_() + (rand.nextDouble() * 6.0 - 3.0) / 16.0;
        world.m_7106_((ParticleOptions)new ElementTypeParticleData(ECParticles.SOURCE_EXHAUSTED, type), x, y, z, 0.0, 0.0, 0.0);
    }

    public static void createCraftingParticle(ElementType type, Level world, Vec3 pos, Random rand) {
        double x = pos.m_7096_() + (rand.nextDouble() * 2.0 - 1.0) / 16.0;
        double y = pos.m_7098_() - 0.1875;
        double z = pos.m_7094_() + (rand.nextDouble() * 2.0 - 1.0) / 16.0;
        IntStream.range(0, 8 + rand.nextInt(5)).forEach(i -> world.m_7106_((ParticleOptions)new ElementTypeParticleData(ECParticles.ELEMENT_CRAFTING, type != ElementType.NONE ? type : ElementType.random(rand)), x, y, z, 0.0, 0.0, 0.0));
    }

    public static void createElementFlowParticle(ElementType type, Level level, Vec3 end, Direction direction, float scale, Random rand) {
        ParticleHelper.createElementFlowParticle(type, level, end, Vec3.m_82528_((Vec3i)direction.m_122424_().m_122436_()).m_82490_(scale <= 0.0f ? 1.0 : (double)scale), new Vec3(3.0, 3.0, 3.0), rand);
    }

    public static void createElementFlowParticle(ElementType type, Level level, Vec3 start, Vec3 end, Random rand) {
        ParticleHelper.createElementFlowParticle(type, level, end, start.m_82546_(end), new Vec3(1.0, 1.0, 1.0), rand);
    }

    private static void createElementFlowParticle(ElementType type, Level level, Vec3 end, Vec3 flow, Vec3 radius, Random rand) {
        double x = end.m_7096_() + (2.0 * rand.nextDouble() - 1.0) * radius.m_7096_() / 16.0;
        double y = end.m_7098_() + (2.0 * rand.nextDouble() - 1.0) * radius.m_7098_() / 16.0;
        double z = end.m_7094_() + (2.0 * rand.nextDouble() - 1.0) * radius.m_7094_() / 16.0;
        level.m_7106_((ParticleOptions)new ElementTypeParticleData(ECParticles.ELEMENT_FLOW, type), x, y, z, flow.m_7096_(), flow.m_7098_(), flow.m_7094_());
    }

    public static void createEnderParticle(Level world, Vec3 pos, int count, Random rand) {
        for (int i = 0; i < count; ++i) {
            int j = rand.nextInt(2) * 2 - 1;
            int k = rand.nextInt(2) * 2 - 1;
            double d0 = pos.m_7096_() + 0.5 + 0.25 * (double)j;
            double d1 = pos.m_7098_() + (double)rand.nextFloat();
            double d2 = pos.m_7094_() + 0.5 + 0.25 * (double)k;
            double d3 = rand.nextFloat() * (float)j;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
            double d5 = rand.nextFloat() * (float)k;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void createItemBreakParticle(Level world, Vec3 pos, Random rand, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 speed = new Vec3(0.0, rand.nextDouble() * 0.1 + 0.1, 0.0);
            Vec3 loc = pos.m_82520_(0.0, rand.nextDouble() * 0.2 - 0.2, 0.0);
            if (world instanceof ServerLevel) {
                ((ServerLevel)world).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), loc.f_82479_, loc.f_82480_, loc.f_82481_, 1, speed.f_82479_, speed.f_82480_ + 0.05, speed.f_82481_, 0.0);
                continue;
            }
            world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), loc.f_82479_, loc.f_82480_, loc.f_82481_, speed.f_82479_, speed.f_82480_ + 0.05, speed.f_82481_);
        }
    }
}

