/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.network.message;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.network.message.MessageHandler;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.tag.ECTags;

public final class ECMessage {
    public static final ECMessage SCROLL_FORWARD = new ECMessage(MessageType.SCROLL_FORWARD);
    public static final ECMessage SCROLL_BACKWORD = new ECMessage(MessageType.SCROLL_BACKWORD);
    private MessageType type = null;

    private ECMessage() {
    }

    private ECMessage(MessageType type) {
        this.type = type;
    }

    public static ECMessage decode(FriendlyByteBuf buf) {
        return new ECMessage((MessageType)buf.m_130066_(MessageType.class));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
    }

    private void handelScroll(ServerPlayer player, int delta) {
        EntityHelper.handStream((Player)player).filter(i -> i.m_204117_(ECTags.Items.SPELL_CAST_TOOLS)).findFirst().ifPresent(i -> SpellHelper.moveSelected(i, delta));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            switch (this.type) {
                case SCROLL_BACKWORD: {
                    this.handelScroll(player, -1);
                    break;
                }
                case SCROLL_FORWARD: {
                    this.handelScroll(player, 1);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void send() {
        MessageHandler.CHANNEL.sendToServer((Object)this);
    }

    public static enum MessageType {
        SCROLL_FORWARD,
        SCROLL_BACKWORD;

    }
}

