/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.jewel.HawkJewel;
import sirttas.elementalcraft.jewel.JewelHelper;
import sirttas.elementalcraft.jewel.Jewels;

@Mixin(value={Projectile.class})
public abstract class MixinProjectile
extends Entity {
    @Unique
    private boolean homing = false;
    @Shadow
    private boolean f_150164_;

    @Shadow
    public abstract Entity m_37282_();

    protected MixinProjectile(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tick$head(CallbackInfo ci) {
        this.handleHoming();
    }

    private void handleHoming() {
        Entity owner;
        MixinProjectile mixinProjectile = this;
        if (mixinProjectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)mixinProjectile;
            if (arrow.f_36703_) {
                return;
            }
        }
        if ((owner = this.m_37282_()) == null) {
            return;
        }
        HawkJewel hawk = (HawkJewel)Jewels.HAWK.get();
        if (!this.f_150164_ && JewelHelper.hasJewel(owner, hawk)) {
            this.homing = true;
            if (!this.f_19853_.f_46443_) {
                hawk.consume(owner);
            }
            return;
        }
        if (!this.homing) {
            return;
        }
        HitResult hit = EntityHelper.rayTrace(owner, 100.0);
        if (hit.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        Vec3 oldDelta = this.m_20184_();
        double length = oldDelta.m_82553_();
        this.m_20256_(hit.m_82450_().m_82546_(this.m_20182_()).m_82541_().m_82549_(oldDelta.m_82541_().m_82490_(3.0)).m_82541_().m_82490_(length));
    }
}

