/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FireInfusionLootModifier
extends LootModifier {
    private static final LootItemFunction FORTUNE = ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_).m_7453_();

    protected FireInfusionLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<GlobalLootModifierSerializer<?>> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)new Serializer().setRegistryName("elementalcraft", "fireinfusion"));
    }

    private ItemStack applyAutoSmelt(ItemStack stack, LootContext context) {
        Optional<Recipe> recipe = context.m_78952_().m_7465_().m_44054_(RecipeType.f_44108_).values().stream().filter(r -> ((Ingredient)r.m_7527_().get(0)).test(stack)).findFirst();
        if (recipe.isPresent()) {
            ItemStack ret = recipe.get().m_8043_().m_41777_();
            ret.m_41764_(ret.m_41613_() * stack.m_41613_());
            if (stack.m_204117_(Tags.Items.ORES)) {
                FORTUNE.apply((Object)ret, (Object)context);
            }
            return ret;
        }
        return stack;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (tool != null && !tool.m_41619_() && ToolInfusionHelper.hasAutoSmelt(tool)) {
            return generatedLoot.stream().map(s -> this.applyAutoSmelt((ItemStack)s, context)).collect(Collectors.toList());
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<FireInfusionLootModifier> {
        public FireInfusionLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new FireInfusionLootModifier(conditions);
        }

        public JsonObject write(FireInfusionLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

