/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.handler;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistryEntry;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.JewelHelper;
import sirttas.elementalcraft.jewel.attack.AbstractAttackJewel;
import sirttas.elementalcraft.jewel.defence.DefenceJewel;
import sirttas.elementalcraft.jewel.effect.EffectJewel;
import sirttas.elementalcraft.jewel.handler.ActiveJewelsMessage;
import sirttas.elementalcraft.jewel.handler.IJewelHandler;
import sirttas.elementalcraft.network.message.MessageHelper;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class JewelHandler
implements IJewelHandler {
    private static final List<JewelHandler> FUTURE_HANDLERS = new ArrayList<JewelHandler>();
    private static final List<JewelHandler> HANDLERS = new ArrayList<JewelHandler>();
    private final Entity entity;
    private final IElementStorage elementStorage;
    private List<Jewel> activeJewels;
    private Multimap<Attribute, AttributeModifier> oldAttributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JewelHandler(Entity entity, IElementStorage elementStorage) {
        this.entity = entity;
        this.elementStorage = elementStorage;
        this.activeJewels = new ArrayList<Jewel>();
        List<JewelHandler> list = FUTURE_HANDLERS;
        synchronized (list) {
            FUTURE_HANDLERS.add(this);
        }
    }

    @Nullable
    public static ICapabilityProvider createProvider(Entity entity, IElementStorage elementStorage) {
        if (JEWEL_HANDLER_CAPABILITY != null) {
            final JewelHandler handler = new JewelHandler(entity, elementStorage);
            return new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
                    return IJewelHandler.JEWEL_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> handler));
                }
            };
        }
        return null;
    }

    @Override
    @Nonnull
    public List<Jewel> getActiveJewels() {
        return List.copyOf(this.activeJewels);
    }

    private void tick() {
        ArrayList<Jewel> jewels = new ArrayList<Jewel>();
        for (Jewel jewel : JewelHelper.getAllJewels(this.entity)) {
            if (!jewel.isActive(this.entity, this.elementStorage)) continue;
            jewels.add(jewel);
            if (!jewel.isTicking()) continue;
            jewel.consume(this.entity, this.elementStorage);
            if (!(jewel instanceof EffectJewel)) continue;
            EffectJewel effectJewel = (EffectJewel)jewel;
            effectJewel.apply(this.entity);
        }
        if (jewels.size() != this.activeJewels.size()) {
            jewels.sort(Comparator.comparing(ForgeRegistryEntry::getRegistryName));
        }
        if (!jewels.equals(this.activeJewels)) {
            this.activeJewels = jewels;
            this.onActiveJewelsChanged();
        }
    }

    private void onActiveJewelsChanged() {
        this.reloadAttributes();
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MessageHelper.sendToPlayer(player, ActiveJewelsMessage.create(this));
        }
    }

    private void reloadAttributes() {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Multimap<Attribute, AttributeModifier> attributes = JewelHelper.getJewelsAttribute(this.entity);
            AttributeMap entityAttributes = livingEntity.m_21204_();
            if (this.oldAttributes != null) {
                entityAttributes.m_22161_(this.oldAttributes);
            }
            entityAttributes.m_22178_(attributes);
            this.oldAttributes = attributes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            List<JewelHandler> list = FUTURE_HANDLERS;
            synchronized (list) {
                HANDLERS.addAll(FUTURE_HANDLERS);
                FUTURE_HANDLERS.clear();
            }
            Iterator<JewelHandler> it = HANDLERS.iterator();
            while (it.hasNext()) {
                JewelHandler handler = it.next();
                if (handler.entity.m_146910_()) {
                    it.remove();
                    continue;
                }
                handler.tick();
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(@Nonnull LivingAttackEvent event) {
        DamageSource source = event.getSource();
        if (source.m_19385_().startsWith("elementalcraft.jewel.")) {
            return;
        }
        Entity attacker = source.m_7639_();
        if (attacker instanceof Projectile) {
            Projectile projectile = (Projectile)attacker;
            attacker = projectile.m_37282_();
        }
        if (attacker != null) {
            for (Jewel jewel : JewelHelper.getActiveJewels(attacker)) {
                if (!(jewel instanceof AbstractAttackJewel)) continue;
                AbstractAttackJewel attackJewel = (AbstractAttackJewel)jewel;
                attackJewel.onAttack(attacker, event.getEntityLiving());
                if (jewel.isTicking()) continue;
                jewel.consume(attacker);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(@Nonnull LivingDamageEvent event) {
        LivingEntity target = event.getEntityLiving();
        for (Jewel jewel : JewelHelper.getActiveJewels((Entity)target)) {
            if (!(jewel instanceof DefenceJewel)) continue;
            DefenceJewel defenceJewel = (DefenceJewel)jewel;
            defenceJewel.onHurt((Entity)target, event.getSource(), event.getAmount());
            if (jewel.isTicking()) continue;
            jewel.consume((Entity)target);
        }
    }
}

