/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.effect;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.jewel.effect.EffectJewel;

public class BasiliskJewel
extends EffectJewel {
    public static final String NAME = "basilisk";

    public BasiliskJewel() {
        super(ElementType.WATER, 20, new MobEffectInstance(MobEffects.f_19597_, 2, 3), new MobEffectInstance(MobEffects.f_19599_, 2, 2));
    }

    private Entity getTarget(Entity entity) {
        HitResult hit = EntityHelper.rayTrace(entity);
        if (hit.m_6662_() == HitResult.Type.ENTITY && hit instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hit;
            return entityHitResult.m_82443_();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isActive(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        if (!super.isActive(entity, elementStorage)) {
            return false;
        }
        Entity target = this.getTarget(entity);
        if (target == null) {
            return false;
        }
        if (entity.m_7307_(target)) return false;
        if (!(target instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)target;
        if (!this.effects.stream().allMatch(arg_0 -> ((LivingEntity)livingEntity).m_7301_(arg_0))) return false;
        return true;
    }

    @Override
    public void apply(Entity entity) {
        Entity target = this.getTarget(entity);
        if (target != null) {
            super.apply(target);
        }
    }

    @Override
    public void appendHoverText(List<Component> tooltip) {
        tooltip.add((Component)new TranslatableComponent("tooltip.elementalcraft.basilisk").m_130940_(ChatFormatting.BLUE));
        super.appendHoverText(tooltip);
    }
}

