/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistryEntry;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;

public class Jewel
extends ForgeRegistryEntry<Jewel>
implements IElementTypeProvider {
    private final ElementType elementType;
    private final int consumption;
    protected boolean ticking = true;

    protected Jewel(ElementType elementType, int consumption) {
        this.elementType = elementType;
        this.consumption = consumption;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public int getConsumption() {
        return this.consumption;
    }

    public boolean isTicking() {
        return this.ticking;
    }

    public ResourceLocation getModelName() {
        ResourceLocation id = this.getRegistryName();
        return new ResourceLocation(id.m_135827_(), "elementalcraft_jewels/" + id.m_135815_());
    }

    public Component getDisplayName() {
        ResourceLocation id = this.getRegistryName();
        return new TranslatableComponent("elementalcraft_jewel." + id.m_135827_() + "." + id.m_135815_());
    }

    public boolean isActive(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        Player player;
        return entity instanceof Player && (player = (Player)entity).m_7500_() || elementStorage != null && elementStorage.extractElement(this.consumption, this.elementType, true) == this.consumption;
    }

    public final void consume(@Nonnull Entity entity) {
        this.consume(entity, (IElementStorage)CapabilityElementStorage.get((ICapabilityProvider)entity).orElse(null));
    }

    public void consume(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        if (elementStorage != null) {
            elementStorage.extractElement(this.consumption, this.elementType, false);
        }
    }

    public void appendHoverText(List<Component> tooltip) {
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent("tooltip.elementalcraft.consumes", new Object[]{this.elementType.getDisplayName()}).m_130940_(ChatFormatting.YELLOW));
    }
}

