/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell.book;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.item.spell.book.SpellBookMenu;
import sirttas.elementalcraft.property.ECProperties;
import sirttas.elementalcraft.spell.SpellHelper;

public class SpellBookItem
extends ECItem {
    public static final String NAME = "spell_book";

    public SpellBookItem() {
        super(ECProperties.Items.ITEM_UNSTACKABLE);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return new InteractionResultHolder(this.open(world, player, stack), (Object)stack);
    }

    public InteractionResult open(Level world, Player player, ItemStack stack) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_((MenuProvider)new ContainerProvider(stack));
        return InteractionResult.CONSUME;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        SpellHelper.forEachSpell(stack, (spell, count) -> {
            if (count == 1) {
                tooltip.add((Component)new TextComponent("").m_7220_(spell.getDisplayName()).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)new TextComponent(count + " ").m_7220_(spell.getDisplayName()).m_130940_(ChatFormatting.GRAY));
            }
        });
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return Math.round((float)((Integer)ECConfig.COMMON.spellBookMaxSpell.get()).intValue() - (float)SpellHelper.getSpellCount(stack) * 13.0f / (float)((Integer)ECConfig.COMMON.spellBookMaxSpell.get()).intValue());
    }

    private static class ContainerProvider
    implements MenuProvider {
        private final ItemStack stack;

        private ContainerProvider(ItemStack stack) {
            this.stack = stack;
        }

        public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player palyer) {
            return SpellBookMenu.create(id, inventory, this.stack);
        }

        @Nonnull
        public Component m_5446_() {
            return this.stack.m_41786_();
        }
    }
}

