/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.Lazy;
import sirttas.elementalcraft.ElementalCraftTab;
import sirttas.elementalcraft.item.spell.FocusItem;
import sirttas.elementalcraft.tag.ECTags;

public class StaffItem
extends FocusItem {
    public static final String NAME = "staff";
    protected static final UUID BASE_ATTACK_RANGE_UUID = UUID.fromString("f413e701-0c60-4333-a9bb-a9dc0d73901e");
    private static final Lazy<Multimap<Attribute, AttributeModifier>> ATTRIBUTE_MODIFIERS = Lazy.of(() -> {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 8.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.2, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ATTACK_RANGE.get()), (Object)new AttributeModifier(BASE_ATTACK_RANGE_UUID, "Attack range", 1.0, AttributeModifier.Operation.ADDITION));
        return builder.build();
    });

    public StaffItem() {
        super(new Item.Properties().m_41491_(ElementalCraftTab.TAB).m_41503_(2252).m_41486_());
    }

    public boolean m_6777_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public float m_8102_(@Nonnull ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        Material material = state.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && !state.m_204336_(BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
    }

    public boolean m_7579_(ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(@Nonnull ItemStack stack, @Nonnull Level level, BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        if (state.m_60800_((BlockGetter)level, pos) > 0.0f) {
            stack.m_41622_(2, entity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8096_(BlockState state) {
        return state.m_60713_(Blocks.f_50033_);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        map.putAll(super.getAttributeModifiers(equipmentSlot, stack));
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            map.putAll((Multimap)ATTRIBUTE_MODIFIERS.get());
        }
        return map;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)new TranslatableComponent("tooltip.elementalcraft.staff.range").m_130940_(ChatFormatting.BLUE));
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction) || super.canPerformAction(stack, toolAction);
    }

    @Nonnull
    public AABB getSweepHitBox(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull Entity target) {
        AABB playerAABB = player.m_142469_().m_82377_(2.0, 0.25, 2.0);
        AABB targetAABB = super.getSweepHitBox(stack, player, target);
        return new AABB(Math.min(playerAABB.f_82288_, targetAABB.f_82288_), Math.min(playerAABB.f_82289_, targetAABB.f_82289_), Math.min(playerAABB.f_82290_, targetAABB.f_82290_), Math.max(playerAABB.f_82291_, targetAABB.f_82291_), Math.max(playerAABB.f_82292_, targetAABB.f_82292_), Math.max(playerAABB.f_82293_, targetAABB.f_82293_));
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(ECTags.Items.INGOTS_FIREITE);
    }

    @Deprecated
    public int m_6473_() {
        return 16;
    }

    @Deprecated
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.WEAPON || super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

