/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source.receptacle;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.source.trait.SourceTraitHelper;
import sirttas.elementalcraft.item.source.receptacle.AbstractReceptacleItem;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;

public class ReceptacleItem
extends AbstractReceptacleItem {
    public static final String NAME = "receptacle";

    public ReceptacleItem() {
    }

    public ReceptacleItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        ItemStack sourceReceptacle = context.m_43722_();
        ElementType elementType = ReceptacleHelper.getElementType(sourceReceptacle);
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPlaceContext newContext = new BlockPlaceContext(context);
        BlockPos pos = newContext.m_8083_();
        if (newContext.m_7059_()) {
            world.m_46597_(pos, (BlockState)((Block)ECBlocks.SOURCE.get()).m_49966_().m_61124_(ElementType.STATE_PROPERTY, (Comparable)((Object)elementType)));
            BlockItem.m_40582_((Level)world, (Player)player, (BlockPos)pos, (ItemStack)sourceReceptacle);
            if (!player.m_7500_()) {
                ItemStack stack = ReceptacleHelper.createFrom(sourceReceptacle, ElementType.NONE);
                if (stack.m_41763_()) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                player.m_21008_(hand, stack);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public String m_5671_(@Nonnull ItemStack stack) {
        return this.m_5524_() + "." + ReceptacleHelper.getElementType(stack).m_7912_();
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            for (ElementType elementType : ElementType.values()) {
                if (elementType == ElementType.NONE) continue;
                items.add((Object)ReceptacleHelper.create(elementType));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        boolean analyzed;
        CompoundTag blockEntityTag = stack.m_41737_("BlockEntityTag");
        if (blockEntityTag != null && (analyzed = blockEntityTag.m_128471_("analyzed"))) {
            blockEntityTag.m_128379_("analyzed", true);
            for (ISourceTraitValue value : SourceTraitHelper.loadTraits(blockEntityTag.m_128469_("traits")).values()) {
                tooltip.add(value.getDescription());
            }
        }
    }
}

