/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source.analysis;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.source.trait.SourceTraitHelper;
import sirttas.elementalcraft.container.menu.AbstractECMenu;
import sirttas.elementalcraft.container.menu.ECMenus;
import sirttas.elementalcraft.item.source.analysis.SourceAnalysisGlassItem;
import sirttas.elementalcraft.item.source.analysis.SourceAnalysisGlassMessage;
import sirttas.elementalcraft.network.message.MessageHelper;
import sirttas.elementalcraft.tag.ECTags;

public class SourceAnalysisGlassMenu
extends AbstractECMenu {
    private final Container input;
    private final Container output;
    private final Player player;
    private final ContainerLevelAccess worldPosCallable;
    private Map<SourceTrait, ISourceTraitValue> traits;

    public SourceAnalysisGlassMenu(int id, Inventory inventory) {
        this(id, inventory, new HashMap<SourceTrait, ISourceTraitValue>(), ContainerLevelAccess.f_39287_);
    }

    public SourceAnalysisGlassMenu(int id, Inventory inventory, Map<SourceTrait, ISourceTraitValue> traits, ContainerLevelAccess worldPosCallable) {
        super(ECMenus.SOURCE_ANALYSIS_GLASS, id);
        this.player = inventory.f_35978_;
        this.input = new CraftingContainer((AbstractContainerMenu)this, 1, 1);
        this.output = new SimpleContainer(1);
        this.worldPosCallable = worldPosCallable;
        this.traits = traits;
        this.addSlots(inventory);
    }

    private void addSlots(Inventory inventory) {
        this.m_38897_(new InputSlot(0, 152, 18));
        this.m_38897_(new OutputSlot(0, 152, 66));
        this.addPlayerSlots(inventory, 98);
    }

    public Map<SourceTrait, ISourceTraitValue> getTraits() {
        return this.traits;
    }

    public void setTraits(Map<SourceTrait, ISourceTraitValue> traits) {
        this.traits = traits;
    }

    @Override
    public void onOpen(Player player) {
        this.sendTraits();
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            ItemStack stack = slotStack.m_41777_();
            if (index < 1) {
                if (!this.m_38903_(slotStack, 2, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (index < 2) {
                    if (!this.m_38903_(slotStack, 2, this.f_38839_.size(), true)) {
                        return ItemStack.f_41583_;
                    }
                    slot.m_142406_(player, slotStack);
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(slotStack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private void analyseReceptacle() {
        boolean analyzed;
        CompoundTag blockEntityTag;
        ItemStack stack = this.input.m_8020_(0);
        if (!stack.m_41619_() && this.output.m_8020_(0).m_41619_() && (blockEntityTag = stack.m_41737_("BlockEntityTag")) != null && ((analyzed = blockEntityTag.m_128471_("analyzed")) || SourceAnalysisGlassItem.consumeSpringaline(this.player))) {
            blockEntityTag.m_128379_("analyzed", true);
            SourceTraitHelper.loadTraits(blockEntityTag.m_128469_("traits"), this.traits);
            this.output.m_6836_(0, stack);
            this.input.m_6836_(0, ItemStack.f_41583_);
            this.sendTraits();
        }
    }

    public void m_6199_(@Nonnull Container inv) {
        this.worldPosCallable.m_39292_((world, pos) -> this.analyseReceptacle());
    }

    @Override
    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.worldPosCallable.m_39292_((level, pos) -> {
            this.m_150411_(player, this.input);
            this.m_150411_(player, this.output);
        });
    }

    private void sendTraits() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MessageHelper.sendToPlayer(serverPlayer, new SourceAnalysisGlassMessage(this.traits));
        }
    }

    private class InputSlot
    extends Slot {
        public InputSlot(int index, int xPosition, int yPosition) {
            super(SourceAnalysisGlassMenu.this.input, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_204117_(ECTags.Items.RECEPTACLES_FULL);
        }

        public void m_6654_() {
            super.m_6654_();
            SourceAnalysisGlassMenu.this.worldPosCallable.m_39292_((level, pos) -> SourceAnalysisGlassMenu.this.analyseReceptacle());
        }
    }

    private class OutputSlot
    extends Slot {
        public OutputSlot(int index, int xPosition, int yPosition) {
            super(SourceAnalysisGlassMenu.this.output, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }
    }
}

