/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.holder;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.source.ISourceInteractable;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.holder.AbstractElementHolderItem;

public class PureElementHolderItem
extends AbstractElementHolderItem
implements ISourceInteractable {
    public static final String NAME = "pure_element_holder";

    public PureElementHolderItem() {
        super((Integer)ECConfig.COMMON.pureElementHolderCapacity.get(), (Integer)ECConfig.COMMON.pureElementHolderTransferAmount.get());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        ElementStorage storage = new ElementStorage(stack);
        if (nbt != null && nbt.m_128441_("Parent")) {
            storage.deserializeNBT(nbt.m_128469_("Parent"));
        }
        return CapabilityElementStorage.createProvider(storage);
    }

    @Override
    public IElementStorage getElementStorage(ItemStack stack) {
        return (IElementStorage)CapabilityElementStorage.get((ICapabilityProvider)stack).orElse((Object)new ElementStorage(stack));
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            ItemStack full = new ItemStack((ItemLike)this);
            IElementStorage storage = this.getElementStorage(full);
            ElementType.ALL_VALID.forEach(elementType -> storage.insertElement(this.elementCapacity, (ElementType)elementType, false));
            items.add((Object)new ItemStack((ItemLike)this));
            items.add((Object)full);
        }
    }

    @Override
    protected ElementType getElementType(IElementStorage target, BlockState blockstate) {
        if (blockstate.m_61138_(ElementType.STATE_PROPERTY)) {
            return ElementType.getElementType(blockstate);
        }
        if (target instanceof IElementTypeProvider) {
            return ((IElementTypeProvider)((Object)target)).getElementType();
        }
        return ElementType.NONE;
    }

    private class ElementStorage
    implements IElementStorage,
    INBTSerializable<CompoundTag> {
        private final ItemStack stack;
        private final Map<ElementType, Integer> amounts = new EnumMap<ElementType, Integer>(ElementType.class);

        public ElementStorage(ItemStack stack) {
            this.stack = stack;
            ElementType.ALL_VALID.forEach(type -> this.amounts.put((ElementType)type, 0));
        }

        @Override
        public boolean usableInInventory() {
            return true;
        }

        @Override
        public int getElementAmount(ElementType type) {
            this.refresh();
            return this.amounts.getOrDefault(type, 0);
        }

        @Override
        public int getElementCapacity(ElementType type) {
            return PureElementHolderItem.this.elementCapacity;
        }

        @Override
        public int insertElement(int count, ElementType type, boolean simulate) {
            int amount = this.getElementAmount(type);
            int newCount = Math.min(amount + count, PureElementHolderItem.this.elementCapacity);
            int ret = count - newCount + amount;
            if (!simulate) {
                this.amounts.put(type, newCount);
                this.updateAmount();
            }
            return ret;
        }

        @Override
        public int extractElement(int count, ElementType type, boolean simulate) {
            int amount = this.getElementAmount(type);
            int newCount = Math.max(amount - count, 0);
            int ret = amount - newCount;
            if (!simulate) {
                this.amounts.put(type, newCount);
                this.updateAmount();
            }
            return ret;
        }

        private void refresh() {
            this.deserializeNBT(this.stack.m_41783_());
        }

        private void updateAmount() {
            this.serializeNBT(this.stack.m_41784_());
        }

        public CompoundTag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            this.serializeNBT(compound);
            return compound;
        }

        private void serializeNBT(CompoundTag compound) {
            this.amounts.forEach((elementType, amount) -> compound.m_128405_(elementType.m_7912_(), amount.intValue()));
        }

        public void deserializeNBT(CompoundTag compound) {
            this.amounts.replaceAll((elementType, amount) -> {
                if (compound != null && compound.m_128441_(elementType.m_7912_())) {
                    return compound.m_128451_(elementType.m_7912_());
                }
                return 0;
            });
        }
    }
}

