/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.elemental;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.item.elemental.ElementalItem;
import sirttas.elementalcraft.property.ECProperties;

public class LenseItem
extends ElementalItem {
    private static final String NAME = "lense";
    public static final String NAME_FIRE = "fire_lense";
    public static final String NAME_WATER = "water_lense";
    public static final String NAME_EARTH = "earth_lense";
    public static final String NAME_AIR = "air_lense";

    public LenseItem(ElementType elementType) {
        super(ECProperties.Items.LENSE, elementType);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
                return CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> LenseItem.this.getStorage(stack, 1)));
            }
        };
    }

    @Nonnull
    public IElementStorage getStorage(ItemStack stack, int multiplier) {
        return new Storage(stack, multiplier);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44986_;
    }

    private class Storage
    implements ISingleElementStorage {
        private final int multiplier;
        private final ItemStack stack;

        private Storage(ItemStack stack, int multiplier) {
            this.stack = stack;
            this.multiplier = multiplier;
        }

        @Override
        public ElementType getElementType() {
            return LenseItem.this.elementType;
        }

        @Override
        public int getElementAmount() {
            return (this.stack.m_41776_() - this.stack.m_41773_()) * this.multiplier;
        }

        @Override
        public int getElementCapacity() {
            return this.stack.m_41776_() * this.multiplier;
        }

        @Override
        public int insertElement(int count, ElementType type, boolean simulate) {
            return count;
        }

        @Override
        public int extractElement(int count, ElementType type, boolean simulate) {
            if (!this.stack.m_41763_()) {
                return count;
            }
            Random rand = new Random();
            ItemStack target = simulate ? this.stack.m_41777_() : this.stack;
            int damage = target.m_41773_();
            int floor = this.randomFloor(rand, count);
            if (floor == 0) {
                return count;
            }
            target.m_41629_(floor, rand, null);
            return Math.min(count, (target.m_41773_() - damage) * this.multiplier);
        }

        private int randomFloor(Random rand, float count) {
            float v = count / (float)this.multiplier;
            int floor = (int)Math.floor(v);
            if (rand.nextDouble() < (double)(v - (float)floor)) {
                return floor + 1;
            }
            return floor;
        }
    }
}

