/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.color.ColorGetter;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.property.ECProperties;

public class ECItem
extends Item {
    private static boolean noJeiLogged = false;
    private boolean glint = false;

    public ECItem() {
        this(ECProperties.Items.DEFAULT_ITEM_PROPERTIES);
    }

    public ECItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(@Nonnull ItemStack stack) {
        return this.glint || super.m_5812_(stack);
    }

    public ECItem setEffect(boolean glint) {
        this.glint = glint;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int lookupColor(ItemStack stack) {
        block3: {
            try {
                List colors = ColorGetter.getColors((ItemStack)stack, (int)2);
                if (colors != null && !colors.isEmpty()) {
                    return (Integer)colors.get(0);
                }
            }
            catch (NoClassDefFoundError e) {
                if (noJeiLogged) break block3;
                ElementalCraftApi.LOGGER.warn("JEI not present, can't lookup item colors", (Throwable)e);
                noJeiLogged = true;
            }
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addAttributeMultiMapToTooltip(List<Component> tooltip, Multimap<Attribute, AttributeModifier> multiMap) {
        ECItem.addAttributeMultiMapToTooltip(tooltip, multiMap, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addAttributeMultiMapToTooltip(List<Component> tooltip, Multimap<Attribute, AttributeModifier> multiMap, @Nullable Component title) {
        if (!multiMap.isEmpty()) {
            tooltip.add((Component)new TextComponent(""));
            if (title != null) {
                tooltip.add(title);
            }
            for (Map.Entry entry : multiMap.entries()) {
                tooltip.add((Component)ECItem.getAttributeTooltip((Attribute)entry.getKey(), (AttributeModifier)entry.getValue()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent getAttributeTooltip(Attribute attribute, AttributeModifier attributemodifier) {
        double d0 = attributemodifier.m_22218_();
        double d1 = attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (attribute.equals(Attributes.f_22278_) ? d0 * 10.0 : d0) : d0 * 100.0;
        if (d0 > 0.0) {
            return new TranslatableComponent("attribute.modifier.plus." + attributemodifier.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1), new TranslatableComponent(attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE);
        }
        if (d0 < 0.0) {
            return new TranslatableComponent("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), new TranslatableComponent(attribute.m_22087_())}).m_130940_(ChatFormatting.RED);
        }
        return null;
    }
}

